/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.ClassNodeCache;
import io.papermc.paperweight.util.FileKt;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassVisitor;
import paper.libs.org.objectweb.asm.ClassWriter;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"Lio/papermc/paperweight/util/JarProcessing;", "", "()V", "processClass", "", "file", "Ljava/nio/file/Path;", "outFile", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "processor", "Lio/papermc/paperweight/util/JarProcessing$ClassProcessor;", "processFile", "output", "Ljava/nio/file/FileSystem;", "processJar", "jarFile", "fallbackJar", "ClassProcessor", "paperweight-lib"})
public final class JarProcessing {
    @NotNull
    public static final JarProcessing INSTANCE = new JarProcessing();

    private JarProcessing() {
    }

    public final void processJar(@NotNull FileSystem jarFile, @NotNull FileSystem output, @NotNull ClassProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.processJar(jarFile, null, output, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processJar(@NotNull FileSystem jarFile, @Nullable FileSystem fallbackJar, @NotNull FileSystem output, @NotNull ClassProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Object object = new FileSystem[]{fallbackJar};
        ClassNodeCache classNodeCache = ClassNodeCache.Companion.create(jarFile, (FileSystem)object);
        object = FileKt.walk(jarFile);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl = false;
            stream.forEach(new Consumer(output, classNodeCache, processor){
                final /* synthetic */ FileSystem $output;
                final /* synthetic */ ClassNodeCache $classNodeCache;
                final /* synthetic */ ClassProcessor $processor;
                {
                    this.$output = $output;
                    this.$classNodeCache = $classNodeCache;
                    this.$processor = $processor;
                }

                public final void accept(Path file2) {
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    JarProcessing.access$processFile(JarProcessing.INSTANCE, file2, this.$output, this.$classNodeCache, this.$processor);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    private final void processFile(Path file2, FileSystem output, ClassNodeCache classNodeCache, ClassProcessor processor) {
        Path outFile = output.getPath(((Object)file2.toAbsolutePath()).toString(), new String[0]);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(outFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            return;
        }
        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)file2), (String)".class", (boolean)false, (int)2, null)) {
            Path path = file2;
            Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
            Path path2 = outFile;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            return;
        }
        if (processor.shouldProcess(file2)) {
            Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
            this.processClass(file2, outFile, classNodeCache, processor);
        } else {
            Path path = file2;
            Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
            Path path3 = outFile;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    private final void processClass(Path file2, Path outFile, ClassNodeCache classNodeCache, ClassProcessor processor) {
        ClassVisitor classVisitor;
        ClassNode classNode = classNodeCache.findClass(((Object)file2).toString());
        if (classNode == null) {
            throw new IllegalStateException(("No ClassNode found for known entry: " + PathsKt.getName((Path)file2)).toString());
        }
        ClassNode node = classNode;
        ClassWriter writer = new ClassWriter(0);
        Object object = processor;
        if (object instanceof ClassProcessor.VisitorBased) {
            classVisitor = ((ClassProcessor.VisitorBased)processor).processClass(node, writer, classNodeCache);
            if (classVisitor == null) {
                classVisitor = writer;
            }
        } else if (object instanceof ClassProcessor.NodeBased) {
            ((ClassProcessor.NodeBased)processor).processClass(node, classNodeCache);
            classVisitor = writer;
        } else {
            throw new IllegalStateException(("Unknown class processor type: " + processor.getClass().getName()).toString());
        }
        ClassVisitor visitor = classVisitor;
        node.accept(visitor);
        object = outFile;
        byte[] byArray2 = writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"writer.toByteArray()");
        byte[] byArray3 = byArray2;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write((Path)object, byArray3, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    public static final /* synthetic */ void access$processFile(JarProcessing $this, Path file2, FileSystem output, ClassNodeCache classNodeCache, ClassProcessor processor) {
        $this.processFile(file2, output, classNodeCache, processor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0006\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/util/JarProcessing$ClassProcessor;", "", "shouldProcess", "", "file", "Ljava/nio/file/Path;", "NodeBased", "VisitorBased", "paperweight-lib"})
    public static interface ClassProcessor {
        default public boolean shouldProcess(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return true;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/util/JarProcessing$ClassProcessor$NodeBased;", "Lio/papermc/paperweight/util/JarProcessing$ClassProcessor;", "processClass", "", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "paperweight-lib"})
        public static interface NodeBased
        extends ClassProcessor {
            public void processClass(@NotNull ClassNode var1, @NotNull ClassNodeCache var2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/util/JarProcessing$ClassProcessor$VisitorBased;", "Lio/papermc/paperweight/util/JarProcessing$ClassProcessor;", "processClass", "Lpaper/libs/org/objectweb/asm/ClassVisitor;", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "parent", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "paperweight-lib"})
        public static interface VisitorBased
        extends ClassProcessor {
            @Nullable
            public ClassVisitor processClass(@NotNull ClassNode var1, @NotNull ClassVisitor var2, @NotNull ClassNodeCache var3);
        }
    }
}

