/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import io.papermc.paperweight.util.Hash;
import io.papermc.paperweight.util.HashingAlgorithm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006 "}, d2={"Lio/papermc/paperweight/util/data/ManifestVersion;", "", "id", "", "type", "time", "releaseTime", "url", "sha1", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getReleaseTime", "getSha1", "getTime", "getType", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hash", "Lio/papermc/paperweight/util/Hash;", "hashCode", "", "toString", "paperweight-lib"})
public final class ManifestVersion {
    @NotNull
    private final String id;
    @NotNull
    private final String type;
    @NotNull
    private final String time;
    @NotNull
    private final String releaseTime;
    @NotNull
    private final String url;
    @NotNull
    private final String sha1;

    public ManifestVersion(@NotNull String id, @NotNull String type, @NotNull String time, @NotNull String releaseTime, @NotNull String url, @NotNull String sha1) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)releaseTime, (String)"releaseTime");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
        this.id = id;
        this.type = type;
        this.time = time;
        this.releaseTime = releaseTime;
        this.url = url;
        this.sha1 = sha1;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getTime() {
        return this.time;
    }

    @NotNull
    public final String getReleaseTime() {
        return this.releaseTime;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getSha1() {
        return this.sha1;
    }

    @NotNull
    public final Hash hash() {
        return new Hash(this.sha1, HashingAlgorithm.SHA1);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.type;
    }

    @NotNull
    public final String component3() {
        return this.time;
    }

    @NotNull
    public final String component4() {
        return this.releaseTime;
    }

    @NotNull
    public final String component5() {
        return this.url;
    }

    @NotNull
    public final String component6() {
        return this.sha1;
    }

    @NotNull
    public final ManifestVersion copy(@NotNull String id, @NotNull String type, @NotNull String time, @NotNull String releaseTime, @NotNull String url, @NotNull String sha1) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)releaseTime, (String)"releaseTime");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
        return new ManifestVersion(id, type, time, releaseTime, url, sha1);
    }

    public static /* synthetic */ ManifestVersion copy$default(ManifestVersion manifestVersion, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            string = manifestVersion.id;
        }
        if ((n & 2) != 0) {
            string2 = manifestVersion.type;
        }
        if ((n & 4) != 0) {
            string3 = manifestVersion.time;
        }
        if ((n & 8) != 0) {
            string4 = manifestVersion.releaseTime;
        }
        if ((n & 0x10) != 0) {
            string5 = manifestVersion.url;
        }
        if ((n & 0x20) != 0) {
            string6 = manifestVersion.sha1;
        }
        return manifestVersion.copy(string, string2, string3, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        return "ManifestVersion(id=" + this.id + ", type=" + this.type + ", time=" + this.time + ", releaseTime=" + this.releaseTime + ", url=" + this.url + ", sha1=" + this.sha1 + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + this.time.hashCode();
        result2 = result2 * 31 + this.releaseTime.hashCode();
        result2 = result2 * 31 + this.url.hashCode();
        result2 = result2 * 31 + this.sha1.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ManifestVersion)) {
            return false;
        }
        ManifestVersion manifestVersion = (ManifestVersion)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)manifestVersion.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)manifestVersion.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.time, (Object)manifestVersion.time)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.releaseTime, (Object)manifestVersion.releaseTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)manifestVersion.url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sha1, (Object)manifestVersion.sha1);
    }
}

