/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import paper.libs.codechicken.diffpatch.cli.ArchiveFormatValueConverter;
import paper.libs.codechicken.diffpatch.cli.CliOperation;
import paper.libs.codechicken.diffpatch.cli.DiffOperation;
import paper.libs.codechicken.diffpatch.cli.PatchModeValueConverter;
import paper.libs.codechicken.diffpatch.cli.PatchOperation;
import paper.libs.codechicken.diffpatch.util.InputPath;
import paper.libs.codechicken.diffpatch.util.LogLevel;
import paper.libs.codechicken.diffpatch.util.OutputPath;
import paper.libs.codechicken.diffpatch.util.PatchMode;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveFormat;
import paper.libs.codechicken.repack.joptsimple.AbstractOptionSpec;
import paper.libs.codechicken.repack.joptsimple.ArgumentAcceptingOptionSpec;
import paper.libs.codechicken.repack.joptsimple.NonOptionArgumentSpec;
import paper.libs.codechicken.repack.joptsimple.OptionParser;
import paper.libs.codechicken.repack.joptsimple.OptionSet;
import paper.libs.codechicken.repack.joptsimple.OptionSpec;
import paper.libs.codechicken.repack.joptsimple.OptionSpecBuilder;
import paper.libs.codechicken.repack.joptsimple.util.EnumConverter;
import paper.libs.codechicken.repack.joptsimple.util.PathConverter;
import paper.libs.codechicken.repack.joptsimple.util.PathProperties;
import paper.libs.codechicken.repack.net.covers1624.quack.util.SneakyUtils;

public class DiffPatch {
    public static void main(String[] args) throws IOException {
        System.exit(DiffPatch.mainI(args, System.err, System.out));
    }

    public static int mainI(String[] args, PrintStream logger, PrintStream pipe) throws IOException {
        CliOperation operation;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help.").forHelp();
        OptionSpecBuilder verboseOpt = parser.acceptsAll(Arrays.asList("v", "verbose"), "Prints more stuff. Alias for --log-level ALL");
        ArgumentAcceptingOptionSpec<LogLevel> logLevelOpt = parser.acceptsAll(Arrays.asList("l", "log-level"), "Set the Logging level.").availableUnless(verboseOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new EnumConverter<LogLevel>(LogLevel.class){}).defaultsTo(LogLevel.INFO, (LogLevel[])new LogLevel[0]);
        OptionSpecBuilder summaryOpt = parser.acceptsAll(Arrays.asList("s", "summary"), "Prints a changes summary at the end.");
        OptionSpecBuilder doDiffOpt = parser.acceptsAll(Arrays.asList("d", "diff"), "Does a Diff operation.");
        OptionSpecBuilder autoHeaderOpt = parser.acceptsAll(Arrays.asList("h", "auto-header"), "Enables the generation of auto-headers. Using _ as the start2 index.").availableIf(doDiffOpt, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<Integer> contextOpt = parser.acceptsAll(Arrays.asList("c", "context"), "Number of context lines to generate in diffs.").availableIf(doDiffOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo(3, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Path> outputOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Sets the output path.").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<ArchiveFormat> archiveOpt = parser.acceptsAll(Arrays.asList("A", "archive"), "Treat output as an archive. Allows printing multi-output to STDOUT.").withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        OptionSpecBuilder doPatchOpt = parser.acceptsAll(Arrays.asList("p", "patch"), "Does a Patch operation.");
        ArgumentAcceptingOptionSpec<Path> rejectOpt = parser.acceptsAll(Arrays.asList("r", "reject"), "Saves patch rejects to the specified path / archive").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<ArchiveFormat> rejectArchiveOpt = parser.acceptsAll(Arrays.asList("H", "archive-rejects"), "Treat reject output as an archive.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec<Float> fuzzOpt = parser.acceptsAll(Arrays.asList("f", "fuzz"), "The minimum fuzz match quality, anything lower will be treated as a failure.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Float.class).defaultsTo(Float.valueOf(0.5f), (Float[])new Float[0]);
        ArgumentAcceptingOptionSpec<Integer> offsetOpt = parser.acceptsAll(Arrays.asList("O", "offset"), "The max line offset allowed for fuzzy matching, larger than this will be treated as a failure.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo(5, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<PatchMode> modeOpt = parser.acceptsAll(Arrays.asList("m", "mode"), "The desired patching mode.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PatchModeValueConverter()).defaultsTo(PatchMode.EXACT, (PatchMode[])new PatchMode[0]);
        ArgumentAcceptingOptionSpec<String> patchPrefix = parser.acceptsAll(Arrays.asList("P", "prefix"), "Prefix path for reading patches from patches input.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(String.class).defaultsTo("", (String[])new String[0]);
        OptionSet optSet = parser.parse(args);
        if (optSet.has(helpOpt)) {
            parser.printHelpOn(logger);
            return -1;
        }
        LogLevel level = LogLevel.INFO;
        if (optSet.has(logLevelOpt)) {
            level = optSet.valueOf(logLevelOpt);
        } else if (optSet.has(summaryOpt)) {
            level = LogLevel.DEBUG;
        }
        boolean summary = optSet.has(summaryOpt);
        List<String> arguments = optSet.valuesOf(nonOptions);
        if (arguments.size() != 2) {
            logger.println("Expected 2 arguments, got: " + arguments.size());
            parser.printHelpOn(logger);
            return -1;
        }
        if (optSet.has(doDiffOpt)) {
            Path a = Paths.get(arguments.get(0), new String[0]);
            Path b = Paths.get(arguments.get(1), new String[0]);
            Path output = optSet.valueOf(outputOpt);
            ArchiveFormat outputFormat = optSet.valueOf(archiveOpt);
            if (outputFormat == null && output != null) {
                outputFormat = ArchiveFormat.findFormat(output.getFileName());
            }
            OutputPath outputPath = output != null ? new OutputPath.FilePath(output, outputFormat, new OpenOption[0]) : new OutputPath.PipePath(pipe, outputFormat);
            operation = DiffOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(parser::printHelpOn)).aPath(a, ArchiveFormat.findFormat(a.getFileName())).bPath(b, ArchiveFormat.findFormat(b.getFileName())).outputPath(outputPath).level(level).summary(summary).autoHeader(optSet.has(autoHeaderOpt)).context(optSet.valueOf(contextOpt)).build();
        } else if (optSet.has(doPatchOpt)) {
            Path base = Paths.get(arguments.get(0), new String[0]);
            Path patches = Paths.get(arguments.get(1), new String[0]);
            Path output = optSet.valueOf(outputOpt);
            Path rejects = optSet.valueOf(rejectOpt);
            ArchiveFormat outputFormat = optSet.valueOf(archiveOpt);
            ArchiveFormat rejectsFormat = optSet.valueOf(rejectArchiveOpt);
            if (outputFormat == null && output != null) {
                outputFormat = ArchiveFormat.findFormat(output.getFileName());
            }
            if (rejectsFormat == null && rejects != null) {
                rejectsFormat = ArchiveFormat.findFormat(rejects.getFileName());
            }
            InputPath.FilePath basePath = new InputPath.FilePath(base, ArchiveFormat.findFormat(base.getFileName()), new OpenOption[0]);
            InputPath.FilePath patchesPath = new InputPath.FilePath(patches, ArchiveFormat.findFormat(patches.getFileName()), new OpenOption[0]);
            OutputPath outputPath = output != null ? new OutputPath.FilePath(output, outputFormat, new OpenOption[0]) : new OutputPath.PipePath(pipe, outputFormat);
            OutputPath rejectsPath = OutputPath.NullPath.INSTANCE;
            if (rejects != null) {
                rejectsPath = new OutputPath.FilePath(rejects, rejectsFormat, new OpenOption[0]);
            }
            operation = PatchOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(parser::printHelpOn)).level(level).summary(summary).basePath(basePath).patchesPath(patchesPath).outputPath(outputPath).rejectsPath(rejectsPath).minFuzz(optSet.valueOf(fuzzOpt).floatValue()).maxOffset(optSet.valueOf(offsetOpt)).mode(optSet.valueOf(modeOpt)).patchesPrefix(optSet.valueOf(patchPrefix)).build();
        } else {
            logger.println("Expected --diff or --patch.");
            parser.printHelpOn(logger);
            return -1;
        }
        return ((CliOperation)operation).operate().exit;
    }
}

