/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import paper.libs.codechicken.diffpatch.match.FuzzyLineMatcher;
import paper.libs.codechicken.diffpatch.util.CharRepresenter;
import paper.libs.codechicken.diffpatch.util.Diff;
import paper.libs.codechicken.diffpatch.util.LineRange;
import paper.libs.codechicken.diffpatch.util.Operation;
import paper.libs.codechicken.diffpatch.util.Patch;
import paper.libs.codechicken.diffpatch.util.PatchFile;
import paper.libs.codechicken.diffpatch.util.PatchMode;
import paper.libs.codechicken.repack.net.covers1624.quack.collection.ColUtils;
import paper.libs.codechicken.repack.net.covers1624.quack.collection.FastStream;
import paper.libs.codechicken.repack.org.apache.commons.lang3.tuple.Pair;

public class Patcher {
    private static final List<String> ACCESS_WORDS = Arrays.asList("public", "protected", "private", "final", " ", "\t");
    public final List<WorkingPatch> patches;
    public List<String> lines;
    private boolean applied;
    private Patch lastAppliedPatch = null;
    private int searchOffset;
    private final CharRepresenter charRep;
    private String lmText;
    private List<String> wmLines;
    public final int maxMatchOffset;
    public final float minMatchScore;

    public Patcher(PatchFile patchFile, List<String> lines) {
        this(patchFile, lines, null, 0.5f, 5);
    }

    public Patcher(PatchFile patchFile, List<String> lines, float minFuzz, int maxOffset) {
        this(patchFile, lines, null, minFuzz, maxOffset);
    }

    public Patcher(PatchFile patchFile, List<String> lines, CharRepresenter charRep, float minFuzz, int maxOffset) {
        this.patches = FastStream.of(patchFile.patches).map(WorkingPatch::new).toList();
        this.lines = new ArrayList<String>(lines);
        if (charRep == null) {
            charRep = new CharRepresenter();
        }
        this.charRep = charRep;
        this.minMatchScore = minFuzz;
        this.maxMatchOffset = maxOffset;
    }

    public List<Result> patch(PatchMode mode) {
        if (this.applied) {
            throw new RuntimeException("Already applied");
        }
        this.applied = true;
        for (WorkingPatch patch : this.patches) {
            if (this.applyExact(patch) || mode.ordinal() >= PatchMode.ACCESS.ordinal() && this.applyAccess(patch) || mode.ordinal() >= PatchMode.OFFSET.ordinal() && this.applyOffset(patch) || mode.ordinal() >= PatchMode.FUZZY.ordinal() && this.applyFuzzy(patch)) continue;
            patch.fail();
            patch.result.searchOffset = this.searchOffset;
            this.searchOffset -= patch.length2 - patch.length1;
        }
        return FastStream.of(this.patches).map(e -> e.result).toList();
    }

    private void linesToChars() {
        for (WorkingPatch patch : this.patches) {
            patch.linesToChars(this.charRep);
        }
        this.lmText = this.charRep.linesToChars(this.lines);
    }

    private void wordsToChars() {
        for (WorkingPatch patch : this.patches) {
            patch.wordsToChars(this.charRep);
        }
        this.wmLines = FastStream.of(this.lines).map(this.charRep::wordsToChars).toList();
    }

    private Patch applyExactAt(int loc, WorkingPatch patch) {
        if (!patch.getContextLines().equals(this.lines.subList(loc, loc + patch.length1))) {
            throw new RuntimeException("Patch engine failure");
        }
        if (!this.canApplySafelyAt(loc, patch)) {
            throw new RuntimeException("Patch affects another patch");
        }
        this.lines.subList(loc, loc + patch.length1).clear();
        this.lines.addAll(loc, patch.getPatchedLines());
        if (this.lmText != null) {
            this.lmText = this.lmText.substring(0, loc) + patch.lmPatched + this.lmText.substring(loc + patch.length1);
        }
        if (this.wmLines != null) {
            this.wmLines.subList(loc, loc + patch.length1).clear();
            this.wmLines.addAll(loc, patch.wmPatched);
        }
        int patchedDelta = FastStream.of(this.patches).filter(e -> {
            LineRange r = e.getKeepoutRange2();
            return r != null && r.getEnd() <= loc;
        }).intSum(e -> e.getAppliedDelta().getAsInt());
        Patch appliedPatch = patch;
        if (appliedPatch.start2 != loc || appliedPatch.start1 != loc - patchedDelta) {
            appliedPatch = new Patch(patch);
            appliedPatch.start1 = loc - patchedDelta;
            appliedPatch.start2 = loc;
        }
        if (loc < this.getModifiedRange().getEnd()) {
            for (WorkingPatch p : this.patches) {
                LineRange r = p.getKeepoutRange2();
                if (r == null || r.getStart() <= loc) continue;
                p.result.appliedPatch.start2 += appliedPatch.length2 - appliedPatch.length1;
            }
        } else {
            this.lastAppliedPatch = appliedPatch;
        }
        this.searchOffset = appliedPatch.start2 - patch.start2;
        return appliedPatch;
    }

    private boolean canApplySafelyAt(int loc, Patch patch) {
        if (loc >= this.getModifiedRange().getEnd()) {
            return true;
        }
        LineRange range = LineRange.fromStartLen(loc, patch.length1);
        return ColUtils.allMatch(this.patches, p -> {
            LineRange r = p.getKeepoutRange2();
            return r == null || !r.contains(range);
        });
    }

    private boolean applyExact(WorkingPatch patch) {
        int loc = patch.start2 + this.searchOffset;
        if (loc + patch.length1 > this.lines.size()) {
            return false;
        }
        if (!patch.getContextLines().equals(this.lines.subList(loc, loc + patch.length1))) {
            return false;
        }
        patch.succeed(PatchMode.EXACT, this.applyExactAt(loc, patch));
        return true;
    }

    private boolean applyOffset(WorkingPatch patch) {
        if (this.lmText == null) {
            this.linesToChars();
        }
        if (patch.length1 > this.lines.size()) {
            return false;
        }
        int loc = patch.start2 + this.searchOffset;
        if (loc < 0) {
            loc = 0;
        } else if (loc >= this.lines.size()) {
            loc = this.lines.size() - 1;
        }
        int forward = this.lmText.indexOf(patch.lmContext, loc);
        int reverse = this.lmText.lastIndexOf(patch.lmContext, Math.min(loc + patch.lmContext.length(), this.lines.size() - 1));
        if (!this.canApplySafelyAt(forward, patch)) {
            forward = -1;
        }
        if (!this.canApplySafelyAt(reverse, patch)) {
            reverse = -1;
        }
        if (forward < 0 && reverse < 0) {
            return false;
        }
        int found = reverse < 0 || forward >= 0 && forward - loc < loc - reverse ? forward : reverse;
        patch.succeed(PatchMode.OFFSET, this.applyExactAt(found, patch));
        patch.addOffsetResult(found - loc, this.lines.size());
        return true;
    }

    private boolean applyAccess(WorkingPatch patch) {
        int loc;
        if (this.wmLines == null) {
            this.wordsToChars();
        }
        if ((loc = patch.start2 + this.searchOffset) + patch.length1 > this.lines.size()) {
            return false;
        }
        List<String> wmLines = this.wmLines.subList(loc, loc + patch.length1);
        if (patch.wmContext.size() != wmLines.size()) {
            return false;
        }
        int[] aWordCounts = new int[this.charRep.getMaxWordChar()];
        int[] bWordCounts = new int[this.charRep.getMaxWordChar()];
        int[] match = new int[patch.wmContext.size()];
        for (int i2 = 0; i2 < patch.wmContext.size(); ++i2) {
            char c;
            int n;
            match[i2] = loc + i2;
            char[] cArray = patch.wmContext.get(i2).toCharArray();
            int n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                char c2 = c = cArray[n];
                aWordCounts[c2] = aWordCounts[c2] + 1;
            }
            cArray = wmLines.get(i2).toCharArray();
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                char c3 = c = cArray[n];
                bWordCounts[c3] = bWordCounts[c3] + 1;
            }
        }
        int accessChanges = 0;
        for (int i3 = 0; i3 < aWordCounts.length; ++i3) {
            if (aWordCounts[i3] == bWordCounts[i3]) continue;
            if (!ACCESS_WORDS.contains(this.charRep.getWordForChar((char)i3))) {
                return false;
            }
            ++accessChanges;
        }
        if (accessChanges == 0) {
            return false;
        }
        WorkingPatch fuzzyPatch = new WorkingPatch(Patcher.adjustPatchToMatchedLines(patch, match, this.lines));
        fuzzyPatch.wordsToChars(this.charRep);
        if (this.lmText != null) {
            fuzzyPatch.linesToChars(this.charRep);
        }
        patch.succeed(PatchMode.ACCESS, this.applyExactAt(loc, fuzzyPatch));
        return true;
    }

    private boolean applyFuzzy(WorkingPatch patch) {
        Pair<int[], Float> pair;
        int[] match;
        int loc;
        if (this.wmLines == null) {
            this.wordsToChars();
        }
        if ((loc = patch.start2 + this.searchOffset) + patch.length1 > this.wmLines.size()) {
            loc = this.wmLines.size() - patch.length1;
        }
        if ((match = (pair = this.findMatch(loc, patch.wmContext)).getLeft()) == null) {
            return false;
        }
        WorkingPatch fuzzyPatch = new WorkingPatch(Patcher.adjustPatchToMatchedLines(patch, match, this.lines));
        if (this.wmLines != null) {
            fuzzyPatch.wordsToChars(this.charRep);
        }
        if (this.lmText != null) {
            fuzzyPatch.linesToChars(this.charRep);
        }
        int at = 0;
        for (int i2 : match) {
            if (i2 < 0) continue;
            at = i2;
            break;
        }
        patch.succeed(PatchMode.FUZZY, this.applyExactAt(at, fuzzyPatch));
        patch.addOffsetResult(fuzzyPatch.start2 - loc, this.lines.size());
        patch.addFuzzyResult(pair.getRight().floatValue());
        return true;
    }

    public static Patch adjustPatchToMatchedLines(Patch patch, int[] match, List<String> lines) {
        Patch fuzzyPatch = new Patch(patch);
        List<Diff> diffs = fuzzyPatch.diffs;
        int j = 0;
        int ploc = -1;
        for (int i2 = 0; i2 < patch.length1; ++i2) {
            int mloc = match[i2];
            if (mloc >= 0 && ploc >= 0 && mloc - ploc > 1) {
                Operation op2 = diffs.get((int)(j - 1)).op == Operation.DELETE && diffs.get((int)j).op == Operation.DELETE ? Operation.DELETE : Operation.EQUAL;
                for (int l = ploc + 1; l < mloc; ++l) {
                    diffs.add(j++, new Diff(op2, lines.get(l)));
                }
            }
            ploc = mloc;
            while (diffs.get((int)j).op == Operation.INSERT) {
                ++j;
            }
            if (mloc < 0) {
                diffs.remove(j);
                continue;
            }
            diffs.get((int)j++).text = lines.get(mloc);
        }
        fuzzyPatch.recalculateLength();
        return fuzzyPatch;
    }

    private Pair<int[], Float> findMatch(int loc, List<String> wmContext) {
        ArrayList<LineRange> keepoutRanges = FastStream.of(this.patches).map(WorkingPatch::getKeepoutRange2).filter(Objects::nonNull).toList();
        List<LineRange> ranges = LineRange.fromStartLen(0, this.wmLines.size()).except(keepoutRanges);
        return Patcher.fuzzyMatch(wmContext, this.wmLines, loc, this.maxMatchOffset, this.minMatchScore, ranges);
    }

    public static Pair<int[], Float> fuzzyMatch(List<String> wmPattern, List<String> wmText, int loc, int maxMatchOffset, float minMatchScore, List<LineRange> ranges) {
        if (ranges == null) {
            ranges = Collections.singletonList(LineRange.fromStartLen(0, wmText.size()));
        }
        ArrayList<FuzzyLineMatcher.MatchMatrix> fwdMatchers = FastStream.of(ranges).map(r -> new FuzzyLineMatcher.MatchMatrix(wmPattern, wmText, maxMatchOffset, (LineRange)r)).filter(m -> loc < m.workingRange.getLast()).toList();
        ArrayList<FuzzyLineMatcher.MatchMatrix> revMatchers = FastStream.of(ranges).reversed().map(r -> new FuzzyLineMatcher.MatchMatrix(wmPattern, wmText, maxMatchOffset, (LineRange)r)).filter(m -> loc > m.workingRange.getFirst()).toList();
        int warnDist = Patcher.offsetWarnDistance(wmPattern.size(), wmText.size());
        float penaltyPerLine = 1.0f / (float)(10 * warnDist);
        MatchRunner fwd = new MatchRunner(loc, 1, fwdMatchers, penaltyPerLine);
        MatchRunner rev = new MatchRunner(loc, -1, revMatchers, penaltyPerLine);
        AtomicReference<Float> bestScore = new AtomicReference<Float>(Float.valueOf(minMatchScore));
        AtomicReference<Object> bestMatch = new AtomicReference<Object>(null);
        while (fwd.step(bestScore, bestMatch) | rev.step(bestScore, bestMatch)) {
        }
        return Pair.of(bestMatch.get(), bestScore.get());
    }

    private LineRange getModifiedRange() {
        return new LineRange(0, this.lastAppliedPatch != null ? this.lastAppliedPatch.getTrimmedRange2().getEnd() : 0);
    }

    public static int offsetWarnDistance(int patchLength, int fileLength) {
        return Math.max(patchLength * 10, fileLength / 10);
    }

    public static class Result {
        public Patch patch;
        public boolean success;
        public PatchMode mode;
        public int searchOffset;
        public Patch appliedPatch;
        public int offset;
        public boolean offsetWarning;
        public float fuzzyQuality;

        public Result() {
        }

        public Result(Patch patch, boolean success) {
            this.patch = patch;
            this.success = success;
        }

        public String summary() {
            if (!this.success) {
                return "FAILURE: " + this.patch.getHeader();
            }
            if (this.mode == PatchMode.ACCESS) {
                return "ACCESS: " + this.patch.getHeader();
            }
            if (this.mode == PatchMode.OFFSET) {
                return String.format("%s: %s offset %d lines", this.offsetWarning ? "WARNING" : "OFFSET", this.patch.getHeader(), this.offset);
            }
            if (this.mode == PatchMode.FUZZY) {
                int q = (int)(this.fuzzyQuality * 100.0f);
                return String.format("FUZZY: %s quality %s%%%s", this.patch.getHeader(), q, this.offset > 0 ? String.format(" offset %s lines", this.offset) : "");
            }
            return "EXACT: " + this.patch.getHeader();
        }
    }

    public static class WorkingPatch
    extends Patch {
        public Result result;
        public String lmContext;
        public String lmPatched;
        public List<String> wmContext;
        public List<String> wmPatched;

        public WorkingPatch(Patch other) {
            super(other);
        }

        public void fail() {
            this.result = new Result(this, false);
        }

        public void succeed(PatchMode mode, Patch appliedPatch) {
            this.result = new Result(this, true);
            this.result.mode = mode;
            this.result.appliedPatch = appliedPatch;
        }

        public void addOffsetResult(int offset, int fileLength) {
            this.result.offset = offset;
            this.result.offsetWarning = offset > Patcher.offsetWarnDistance(this.length1, fileLength);
        }

        public void addFuzzyResult(float fuzzQuality) {
            this.result.fuzzyQuality = fuzzQuality;
        }

        public void linesToChars(CharRepresenter rep) {
            this.lmContext = rep.linesToChars(this.getContextLines());
            this.lmPatched = rep.linesToChars(this.getPatchedLines());
        }

        public void wordsToChars(CharRepresenter rep) {
            this.wmContext = this.getContextLines(rep::wordsToChars);
            this.wmPatched = this.getPatchedLines(rep::wordsToChars);
        }

        public LineRange getKeepoutRange2() {
            if (this.result != null && this.result.appliedPatch != null) {
                return this.result.appliedPatch.getTrimmedRange2();
            }
            return null;
        }

        public OptionalInt getAppliedDelta() {
            if (this.result != null && this.result.appliedPatch != null) {
                return OptionalInt.of(this.result.appliedPatch.length2 - this.result.appliedPatch.length1);
            }
            return OptionalInt.empty();
        }
    }

    private static class MatchRunner {
        private int loc;
        private final int dir;
        private final List<FuzzyLineMatcher.MatchMatrix> mms;
        private final float penaltyPerLine;
        private LineRange active;
        private float penalty;

        public MatchRunner(int loc, int dir2, List<FuzzyLineMatcher.MatchMatrix> mms, float penaltyPerLine) {
            this.loc = loc;
            this.dir = dir2;
            this.mms = mms;
            this.penaltyPerLine = penaltyPerLine;
            this.active = new LineRange();
            this.penalty = -0.1f;
        }

        public boolean step(AtomicReference<Float> bestScore, AtomicReference<int[]> bestMatch) {
            if (this.active.getFirst() == this.mms.size()) {
                return false;
            }
            if (bestScore.get().floatValue() > 1.0f - this.penalty) {
                return false;
            }
            while (this.active.getEnd() < this.mms.size() && this.mms.get((int)this.active.getEnd()).workingRange.contains(this.loc)) {
                this.active.setEnd(this.active.getEnd() + 1);
            }
            for (int i2 = this.active.getFirst(); i2 <= this.active.getLast(); ++i2) {
                FuzzyLineMatcher.MatchMatrix mm = this.mms.get(i2);
                Pair<Boolean, Float> pair = mm.match(this.loc);
                float score = pair.getRight().floatValue();
                if (!pair.getLeft().booleanValue()) {
                    this.active.setFirst(this.active.getFirst() + 1);
                    continue;
                }
                if (this.penalty > 0.0f) {
                    score -= this.penalty;
                }
                if (!(score > bestScore.get().floatValue())) continue;
                bestScore.set(Float.valueOf(score));
                bestMatch.set(mm.path());
            }
            this.loc += this.dir;
            this.penalty += this.penaltyPerLine;
            return true;
        }
    }
}

