/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.util;

import java.io.OutputStream;
import java.util.function.Consumer;

public class ConsumingOutputStream
extends OutputStream {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private final Consumer<String> consumer;
    private final StringBuilder buffer = new StringBuilder();

    public ConsumingOutputStream(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void write(int b) {
        char ch = (char)(b & 0xFF);
        if (ch == '\r') {
            return;
        }
        this.buffer.append(ch);
        if (ch == '\n') {
            this.flush();
        }
    }

    @Override
    public void flush() {
        String str = this.buffer.toString();
        if (str.endsWith("\n")) {
            str = str.replaceAll("\n", "");
            this.consumer.accept(str);
            this.buffer.setLength(0);
        }
    }
}

