/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.util.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveInputStreamReader;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveReader;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveWriter;
import paper.libs.codechicken.diffpatch.util.archiver.TarArchiveOutputStreamWriter;
import paper.libs.codechicken.diffpatch.util.archiver.ZipArchiveOutputStreamWriter;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public enum ArchiveFormat {
    ZIP("ZIP", new String[]{".zip", ".jar"}){

        @Override
        public ArchiveReader createReader(InputStream is, String prefix) {
            return new ArchiveInputStreamReader(new ZipArchiveInputStream(is), prefix);
        }

        @Override
        public ArchiveWriter createWriter(OutputStream os) {
            return new ZipArchiveOutputStreamWriter(new ZipArchiveOutputStream(os));
        }
    }
    ,
    TAR("TAR", new String[]{".tar"}){

        @Override
        public ArchiveReader createReader(InputStream is, String prefix) {
            return ArchiveFormat.makeTarReader(is, prefix);
        }

        @Override
        public ArchiveWriter createWriter(OutputStream os) {
            return ArchiveFormat.makeTarWriter(os);
        }
    }
    ,
    TAR_XZ("TAR_XZ", new String[]{".tar.xz", ".txz"}){

        @Override
        public ArchiveReader createReader(InputStream is, String prefix) throws IOException {
            return ArchiveFormat.makeTarReader(new XZCompressorInputStream(is), prefix);
        }

        @Override
        public ArchiveWriter createWriter(OutputStream os) throws IOException {
            return ArchiveFormat.makeTarWriter(new XZCompressorOutputStream(os));
        }
    }
    ,
    TAR_GZIP("TAR_GZIP", new String[]{".tar.gz", ".taz", ".tgz"}){

        @Override
        public ArchiveReader createReader(InputStream is, String prefix) throws IOException {
            return ArchiveFormat.makeTarReader(new GzipCompressorInputStream(is), prefix);
        }

        @Override
        public ArchiveWriter createWriter(OutputStream os) throws IOException {
            return ArchiveFormat.makeTarWriter(new GzipCompressorOutputStream(os));
        }
    }
    ,
    TAR_BZIP2("TAR_BZIP2", new String[]{".tar.bz2", ".tb2", ".tbz", ".tbz2", ".tz2"}){

        @Override
        public ArchiveReader createReader(InputStream is, String prefix) throws IOException {
            return ArchiveFormat.makeTarReader(new BZip2CompressorInputStream(is), prefix);
        }

        @Override
        public ArchiveWriter createWriter(OutputStream os) throws IOException {
            return ArchiveFormat.makeTarWriter(new BZip2CompressorOutputStream(os));
        }
    };

    private final String name;
    private final Set<String> fileExtensions;

    private ArchiveFormat(String name2, String ... extensions) {
        this.name = name2;
        this.fileExtensions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(extensions)));
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public static ArchiveFormat findFormat(String fName) {
        for (ArchiveFormat format : ArchiveFormat.values()) {
            for (String ext : format.fileExtensions) {
                if (!fName.endsWith(ext)) continue;
                return format;
            }
        }
        return null;
    }

    public static ArchiveFormat findFormat(Path fName) {
        return ArchiveFormat.findFormat(fName.toString());
    }

    private static ArchiveReader makeTarReader(InputStream is, String prefix) {
        return new ArchiveInputStreamReader(new TarArchiveInputStream(is), prefix);
    }

    private static ArchiveWriter makeTarWriter(OutputStream os) {
        return new TarArchiveOutputStreamWriter(new TarArchiveOutputStream(os));
    }

    public ArchiveReader createReader(InputStream is) throws IOException {
        return this.createReader(is, "");
    }

    public abstract ArchiveReader createReader(InputStream var1, String var2) throws IOException;

    public abstract ArchiveWriter createWriter(OutputStream var1) throws IOException;
}

