/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.BigArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.Hash;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.longs.LongArrays;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.longs.LongComparator;

public final class LongBigArrays {
    public static final long[][] EMPTY_BIG_ARRAY = new long[0][];
    public static final long[][] DEFAULT_EMPTY_BIG_ARRAY = new long[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    private static final int RADIXSORT_NO_REC = 1024;

    private LongBigArrays() {
    }

    @Deprecated
    public static long get(long[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(long[][] array, long index, long value2) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value2;
    }

    @Deprecated
    public static void swap(long[][] array, long first2, long second2) {
        long t = array[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    @Deprecated
    public static void add(long[][] array, long index, long incr) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + incr;
    }

    @Deprecated
    public static void mul(long[][] array, long index, long factor) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] * factor;
    }

    @Deprecated
    public static void incr(long[][] array, long index) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + 1L;
    }

    @Deprecated
    public static void decr(long[][] array, long index) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] - 1L;
    }

    @Deprecated
    public static long length(long[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(long[][] srcArray, long srcPos, long[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(long[][] srcArray, long srcPos, long[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(long[] srcArray, int srcPos, long[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static long[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = new long[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new long[0x8000000];
            }
            base[baseLength - 1] = new long[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new long[0x8000000];
            }
        }
        return base;
    }

    @Deprecated
    public static long[][] wrap(long[] array) {
        return BigArrays.wrap(array);
    }

    @Deprecated
    public static long[][] ensureCapacity(long[][] array, long length) {
        return LongBigArrays.ensureCapacity(array, length, LongBigArrays.length(array));
    }

    @Deprecated
    public static long[][] forceCapacity(long[][] array, long length, long preserve) {
        return BigArrays.forceCapacity(array, length, preserve);
    }

    @Deprecated
    public static long[][] ensureCapacity(long[][] array, long length, long preserve) {
        return length > LongBigArrays.length(array) ? LongBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static long[][] grow(long[][] array, long length) {
        long oldLength = LongBigArrays.length(array);
        return length > oldLength ? LongBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static long[][] grow(long[][] array, long length, long preserve) {
        long oldLength = LongBigArrays.length(array);
        return length > oldLength ? LongBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static long[][] trim(long[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = LongBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = (long[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = LongArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static long[][] setLength(long[][] array, long length) {
        return BigArrays.setLength(array, length);
    }

    @Deprecated
    public static long[][] copy(long[][] array, long offset, long length) {
        return BigArrays.copy(array, offset, length);
    }

    @Deprecated
    public static long[][] copy(long[][] array) {
        return BigArrays.copy(array);
    }

    @Deprecated
    public static void fill(long[][] array, long value2) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value2);
        }
    }

    @Deprecated
    public static void fill(long[][] array, long from, long to, long value2) {
        BigArrays.fill(array, from, to, value2);
    }

    @Deprecated
    public static boolean equals(long[][] a1, long[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(long[][] a) {
        return BigArrays.toString(a);
    }

    @Deprecated
    public static void ensureFromTo(long[][] a, long from, long to) {
        BigArrays.ensureFromTo(LongBigArrays.length(a), from, to);
    }

    @Deprecated
    public static void ensureOffsetLength(long[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(LongBigArrays.length(a), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(long[][] a, long[][] b) {
        if (LongBigArrays.length(a) != LongBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + LongBigArrays.length(a) + " != " + LongBigArrays.length(b));
        }
    }

    private static void vecSwap(long[][] x, long a, long b, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            LongBigArrays.swap(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static long med3(long[][] x, long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = comp.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = comp.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from, long to, LongComparator comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            LongBigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(long[][] x, long from, long to, LongComparator comp) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = LongBigArrays.med3(x, m - s, m, m + s, comp);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = LongBigArrays.med3(x, l, m, n, comp);
        }
        long v = BigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        LongBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(long[][] x, long a, long b, long c) {
        int ab = Long.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = Long.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = Long.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m)) continue;
                m = j;
            }
            if (m == i2) continue;
            LongBigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(long[][] x, LongComparator comp) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x), comp);
    }

    public static void quickSort(long[][] x, long from, long to) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s);
                m = LongBigArrays.med3(x, m - s, m, m + s);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = LongBigArrays.med3(x, l, m, n);
        }
        long v = BigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Long.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Long.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        LongBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(long[][] x) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x));
    }

    public static long binarySearch(long[][] a, long from, long to, long key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            long midVal = BigArrays.get(a, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(long[][] a, long key) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key);
    }

    public static long binarySearch(long[][] a, long from, long to, long key, LongComparator c) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            long midVal = BigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(long[][] a, long key, LongComparator c) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key, c);
    }

    public static void radixSort(long[][] a) {
        LongBigArrays.radixSort(a, 0L, LongBigArrays.length(a));
    }

    public static void radixSort(long[][] a, long from, long to) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(a, first2 + i2) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 7 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c]) {
                long t = BigArrays.get(a, i4 + first2);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    long z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first2);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a, d + first2, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first2, t);
                count2[c] = 0L;
            }
        }
    }

    private static void selectionSort(long[][] a, long[][] b, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m) && (BigArrays.get(a, j) != BigArrays.get(a, m) || BigArrays.get(b, j) >= BigArrays.get(b, m))) continue;
                m = j;
            }
            if (m == i2) continue;
            long t = BigArrays.get(a, i2);
            BigArrays.set(a, i2, BigArrays.get(a, m));
            BigArrays.set(a, m, t);
            t = BigArrays.get(b, i2);
            BigArrays.set(b, i2, BigArrays.get(b, m));
            BigArrays.set(b, m, t);
        }
    }

    public static void radixSort(long[][] a, long[][] b) {
        LongBigArrays.radixSort(a, b, 0L, LongBigArrays.length(a));
    }

    public static void radixSort(long[][] a, long[][] b, long from, long to) {
        int layers = 2;
        if (LongBigArrays.length(a) != LongBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            long[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(k, first2 + i2) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 15 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c]) {
                long t = BigArrays.get(a, i4 + first2);
                long u = BigArrays.get(b, i4 + first2);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    long z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first2);
                    BigArrays.set(a, d + first2, z);
                    z = u;
                    u = BigArrays.get(b, d + first2);
                    BigArrays.set(b, d + first2, z);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first2, t);
                BigArrays.set(b, i4 + first2, u);
                count2[c] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, long[][] a, long[][] b, long from, long to) {
        long i2 = from;
        while (++i2 < to) {
            long t = BigArrays.get(perm, i2);
            long j = i2;
            long u = BigArrays.get(perm, j - 1L);
            while (BigArrays.get(a, t) < BigArrays.get(a, u) || BigArrays.get(a, t) == BigArrays.get(a, u) && BigArrays.get(b, t) < BigArrays.get(b, u)) {
                BigArrays.set(perm, j, u);
                if (from == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, long[][] a, long[][] b, boolean stable) {
        LongBigArrays.ensureSameLength(a, b);
        LongBigArrays.radixSortIndirect(perm, a, b, 0L, BigArrays.length(a), stable);
    }

    public static void radixSortIndirect(long[][] perm, long[][] a, long[][] b, long from, long to, boolean stable) {
        long[][] support;
        if (to - from < 1024L) {
            LongBigArrays.insertionSortIndirect(perm, a, b, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        long[] offsetStack = new long[3826];
        long[] lengthStack = new long[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first2 = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            long[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(BigArrays.get(k, BigArrays.get(perm, i2)) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1L;
            }
            int lastUsed = -1;
            long p = stable ? 0L : first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                }
                pos[i3] = p += count2[i3];
            }
            if (stable) {
                long i4 = first2 + length;
                while (i4-- != first2) {
                    int n = (int)(BigArrays.get(k, BigArrays.get(perm, i4)) >>> shift & 0xFFL ^ (long)signMask);
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i4));
                }
                BigArrays.copy(support, 0L, perm, first2, length);
                p = first2;
                for (int i5 = 0; i5 < 256; ++i5) {
                    if (level < 15 && count2[i5] > 1L) {
                        if (count2[i5] < 1024L) {
                            LongBigArrays.insertionSortIndirect(perm, a, b, p, p + count2[i5]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i5];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i5];
                }
                Arrays.fill(count2, 0L);
                continue;
            }
            long end = first2 + length - count2[lastUsed];
            int c = -1;
            for (long i6 = first2; i6 <= end; i6 += count2[c]) {
                long t = BigArrays.get(perm, i6);
                c = (int)(BigArrays.get(k, t) >>> shift & 0xFFL ^ (long)signMask);
                if (i6 < end) {
                    while (true) {
                        int n = c;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i6) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c = (int)(BigArrays.get(k, t) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    BigArrays.set(perm, i6, t);
                }
                if (level < 15 && count2[c] > 1L) {
                    if (count2[c] < 1024L) {
                        LongBigArrays.insertionSortIndirect(perm, a, b, i6, i6 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i6;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0L;
            }
        }
    }

    public static long[][] shuffle(long[][] a, long from, long to, Random random) {
        return BigArrays.shuffle(a, from, to, random);
    }

    public static long[][] shuffle(long[][] a, Random random) {
        return BigArrays.shuffle(a, random);
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<long[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(long[][] a, long[][] b) {
            return LongBigArrays.equals(a, b);
        }
    }
}

