/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.org.tukaani.xz.check;

import paper.libs.codechicken.repack.org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    public void update(byte[] byArray2, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.crc = crcTable[(byArray2[n++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    public byte[] finish() {
        long l = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray2 = new byte[8];
        for (int j = 0; j < byArray2.length; ++j) {
            byArray2[j] = (byte)(l >> j * 8);
        }
        return byArray2;
    }

    static {
        for (int j = 0; j < crcTable.length; ++j) {
            long l = j;
            for (int k = 0; k < 8; ++k) {
                if ((l & 1L) == 1L) {
                    l = l >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                l >>>= 1;
            }
            CRC64.crcTable[j] = l;
        }
    }
}

