/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import paper.libs.dev.denwav.hypo.asm.AsmConstructorData;
import paper.libs.dev.denwav.hypo.asm.AsmFieldData;
import paper.libs.dev.denwav.hypo.asm.AsmMethodData;
import paper.libs.dev.denwav.hypo.asm.HypoAsmUtil;
import paper.libs.dev.denwav.hypo.core.HypoException;
import paper.libs.dev.denwav.hypo.model.ClassDataProvider;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.ClassKind;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.LazyClassData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassReader;
import paper.libs.org.objectweb.asm.tree.ClassNode;
import paper.libs.org.objectweb.asm.tree.FieldNode;
import paper.libs.org.objectweb.asm.tree.InnerClassNode;
import paper.libs.org.objectweb.asm.tree.MethodNode;

public class AsmClassData
extends LazyClassData {
    @NotNull
    private final ClassNode node;

    public AsmClassData(@NotNull ClassNode node) {
        this.node = node;
    }

    @NotNull
    public ClassNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public String computeName() {
        return this.name();
    }

    @Override
    @NotNull
    public String name() {
        return this.node.name;
    }

    @Override
    @Nullable
    public ClassData computeOuterClass() throws IOException {
        if (this.node.outerClass != null) {
            return this.prov().findClass(this.node.outerClass);
        }
        String thisName = this.name();
        for (int i2 = 0; i2 < this.node.innerClasses.size(); ++i2) {
            InnerClassNode innerClassNode = this.node.innerClasses.get(i2);
            if (!Objects.equals(thisName, innerClassNode.name) || innerClassNode.outerName == null) continue;
            return this.prov().findClass(innerClassNode.outerName);
        }
        return null;
    }

    @Override
    public boolean computeStaticInnerClass() {
        if (this.node.outerClass != null) {
            return (this.node.access & 8) != 0;
        }
        String thisName = this.name();
        for (int i2 = 0; i2 < this.node.innerClasses.size(); ++i2) {
            InnerClassNode innerClassNode = this.node.innerClasses.get(i2);
            if (!Objects.equals(thisName, innerClassNode.name) || innerClassNode.outerName == null) continue;
            return (innerClassNode.access & 8) != 0;
        }
        return false;
    }

    @Override
    public boolean computeIsFinal() {
        return this.isFinal();
    }

    @Override
    public boolean isFinal() {
        return (this.node.access & 0x10) != 0;
    }

    @Override
    public boolean computeIsSynthetic() {
        return this.isSynthetic();
    }

    @Override
    public boolean isSynthetic() {
        return (this.node.access & 0x1000) != 0;
    }

    @Override
    @NotNull
    public ClassKind computeClassKind() {
        return this.kind();
    }

    @Override
    @NotNull
    public ClassKind kind() {
        if ((this.node.access & 0x2000) != 0) {
            return ClassKind.ANNOTATION;
        }
        if ((this.node.access & 0x200) != 0) {
            return ClassKind.INTERFACE;
        }
        if ((this.node.access & 0x400) != 0) {
            return ClassKind.ABSTRACT_CLASS;
        }
        if ((this.node.access & 0x4000) != 0) {
            return ClassKind.ENUM;
        }
        return ClassKind.CLASS;
    }

    @Override
    @NotNull
    public Visibility computeVisibility() {
        return this.visibility();
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return HypoAsmUtil.accessToVisibility(this.node.access);
    }

    @Override
    @Nullable
    public ClassData computeSuperClass() throws IOException {
        String superName = this.node.superName;
        if (superName == null) {
            return null;
        }
        ClassData superClassData = this.prov().findClass(superName);
        if (superClassData == null && this.isRequireFullClasspath()) {
            throw new HypoException("Unable to resolve class data binding for '" + superName + "' which is listed as the super class for '" + this.name() + "'");
        }
        return superClassData;
    }

    @Override
    @NotNull
    public Set<ClassData> computeInterfaces() throws IOException {
        ClassDataProvider prov = this.prov();
        HashSet<ClassData> res = new HashSet<ClassData>();
        for (String inter : this.node.interfaces) {
            ClassData interfaceData = prov.findClass(inter);
            if (interfaceData != null) {
                res.add(interfaceData);
                continue;
            }
            if (!this.isRequireFullClasspath()) continue;
            throw new HypoException("Unable to resolve class data binding for '" + inter + "' which is listed as an interface for '" + this.name() + "'");
        }
        return res;
    }

    @Override
    @NotNull
    public Set<FieldData> computeFields() {
        HashSet<FieldData> res = new HashSet<FieldData>();
        for (FieldNode field : this.node.fields) {
            res.add(new AsmFieldData(this, field));
        }
        return res;
    }

    @Override
    @NotNull
    public Set<MethodData> computeMethods() {
        HashSet<MethodData> res = new HashSet<MethodData>();
        for (MethodNode method : this.node.methods) {
            if (method.name.equals("<init>")) {
                res.add(new AsmConstructorData(this, method));
                continue;
            }
            res.add(new AsmMethodData(this, method));
        }
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static AsmClassData readFile(byte @NotNull [] classData) {
        ClassNode node = new ClassNode(589824);
        new ClassReader(classData).accept(node, 0);
        return new AsmClassData(node);
    }
}

