/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import paper.libs.dev.denwav.hypo.mappings.ClassMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.MappingsChange;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public final class ChangeRegistry {
    @NotNull
    private final ConcurrentHashMap<MemberReference, List<MappingsChange>> changes = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, List<ClassMappingsChange>> classChanges = new ConcurrentHashMap();
    @Nullable
    private String currentContributorName = null;

    public void submitChange(@NotNull MappingsChange change) {
        this.changes.computeIfAbsent(change.target(), k -> new ArrayList()).add(change);
    }

    public void submitChange(@NotNull ClassMappingsChange change) {
        this.classChanges.computeIfAbsent(change.targetClass(), k -> new ArrayList()).add(change);
    }

    public void setCurrentContributorName(@Nullable String currentContributorName) {
        this.currentContributorName = currentContributorName;
    }

    @NotNull
    public Map<MemberReference, List<MappingsChange>> getChanges() {
        return this.changes;
    }

    @NotNull
    public ConcurrentHashMap<String, List<ClassMappingsChange>> getClassChanges() {
        return this.classChanges;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public MappingSet applyChanges(@NotNull MappingSet input) {
        List duplicates = this.changes.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).filter(e -> {
            List changes = (List)e.getValue();
            Class<?> clazz = null;
            for (MappingsChange change : changes) {
                Class<?> changeClazz = change.getClass();
                if (clazz == null) {
                    clazz = changeClazz;
                }
                if (clazz != changeClazz) {
                    return true;
                }
                if (change instanceof MergeableMappingsChange) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            String dupes = duplicates.stream().map(e -> "\t" + e.getKey() + "\n" + ((List)e.getValue()).stream().map(r -> "\t\t" + r).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Multiple changes registered (via " + this.currentContributorName + " contributor) for the following member mappings:\n" + dupes);
        }
        ArrayList<String> failures = null;
        MappingSet result2 = input.copy();
        for (List<MappingsChange> changes : this.changes.values()) {
            MappingsChange change = changes.get(0);
            if (changes.size() == 1) {
                change.applyChange(result2);
                continue;
            }
            if (change instanceof MergeableMappingsChange) {
                boolean shouldApply = true;
                for (int i2 = 1; i2 < changes.size(); ++i2) {
                    MappingsChange nextChange = changes.get(i2);
                    if (nextChange == null) continue;
                    MergeResult<MergeableMappingsChange> mergeResult = ((MergeableMappingsChange)change).mergeWith((MergeableMappingsChange)HypoModelUtil.cast(nextChange));
                    if (mergeResult.isFailure()) {
                        if (failures == null) {
                            failures = new ArrayList<String>();
                        }
                        failures.add("\tCannot merge changes: " + mergeResult.getErrorMessage() + "\n\t\t" + change + "\n\t\t" + nextChange);
                        shouldApply = false;
                        continue;
                    }
                    if (mergeResult.isSuccess()) {
                        change = mergeResult.getMerged();
                        continue;
                    }
                    throw new IllegalStateException("Merge result is somehow neither success nor failure: " + mergeResult);
                }
                if (!shouldApply) continue;
                change.applyChange(result2);
                continue;
            }
            throw new IllegalStateException("Cannot handle multiple non-mergeable changes: " + changes);
        }
        if (failures != null && !failures.isEmpty()) {
            throw new IllegalStateException("Failed to apply mapping set changes from " + this.currentContributorName + " contributor:\n" + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)failures));
        }
        List multiClassChanges = this.classChanges.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toList());
        if (!multiClassChanges.isEmpty()) {
            String dupes = multiClassChanges.stream().map(e -> "\t" + (String)e.getKey() + "\n" + ((List)e.getValue()).stream().map(r -> "\t\t" + r).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Multiple class changes registered (via " + this.currentContributorName + " contributor):\n" + dupes);
        }
        for (List<ClassMappingsChange> changes : this.classChanges.values()) {
            if (changes.isEmpty()) continue;
            changes.get(0).applyChange(result2);
        }
        return result2;
    }

    public void clear() {
        this.changes.clear();
        this.classChanges.clear();
    }
}

