/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.contributors;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public class ChangeContributorSet
implements ChangeContributor {
    @NotNull
    private final @NotNull List<@NotNull ChangeContributor> delegateContributors;

    private ChangeContributorSet(@NotNull @NotNull List<@NotNull ChangeContributor> delegateContributors) {
        this.delegateContributors = delegateContributors;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ChangeContributor wrap(@NotNull @NotNull Collection<@NotNull ChangeContributor> delegates) {
        return new ChangeContributorSet(HypoModelUtil.asImmutableList(delegates));
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) throws Throwable {
        for (ChangeContributor delegate : this.delegateContributors) {
            delegate.contribute(currentClass, classMapping, context, registry);
        }
    }

    @Override
    @NotNull
    public String name() {
        if (this.delegateContributors.size() == 1) {
            return this.delegateContributors.get(0).name();
        }
        return this.delegateContributors.stream().map(ChangeContributor::name).collect(Collectors.joining(", ", "Set[", "]"));
    }
}

