/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.contributors;

import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.dev.denwav.hypo.mappings.changes.RemoveClassMappingChange;
import paper.libs.dev.denwav.hypo.mappings.changes.RemoveMappingChange;
import paper.libs.dev.denwav.hypo.mappings.changes.RemoveParameterMappingChange;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public class RemoveUnusedMappings
implements ChangeContributor {
    private RemoveUnusedMappings() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static RemoveUnusedMappings create() {
        return new RemoveUnusedMappings();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (classMapping == null) {
            return;
        }
        if (currentClass == null) {
            registry.submitChange(RemoveClassMappingChange.of(classMapping.getFullObfuscatedName()));
            return;
        }
        for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
            MethodData method = LorenzUtil.findMethod(currentClass, methodMapping);
            if (method == null) {
                registry.submitChange(RemoveMappingChange.of(MemberReference.of(methodMapping)));
                continue;
            }
            if (method.isConstructor() && methodMapping.getParameterMappings().isEmpty()) {
                registry.submitChange(RemoveMappingChange.of(MemberReference.of(methodMapping)));
                continue;
            }
            MemberReference methodRef = null;
            for (MethodParameterMapping paramMapping : methodMapping.getParameterMappings()) {
                if (method.paramLvt(paramMapping.getIndex()) != null) continue;
                if (methodRef == null) {
                    methodRef = MemberReference.of(method);
                }
                registry.submitChange(RemoveParameterMappingChange.of(methodRef, paramMapping.getIndex()));
            }
        }
        for (FieldMapping fieldMapping : classMapping.getFieldMappings()) {
            if (!LorenzUtil.findField(currentClass, fieldMapping).isEmpty()) continue;
            registry.submitChange(RemoveMappingChange.of(MemberReference.of(fieldMapping)));
        }
    }

    @Override
    @NotNull
    public String name() {
        return "RemoveUnusedMappings";
    }
}

