/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import paper.libs.dev.denwav.hypo.model.DirClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.JarClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.SystemClassProviderRoot;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public interface ClassProviderRoot
extends AutoCloseable {
    public byte @Nullable [] getClassData(@NotNull String var1) throws IOException;

    @NotNull
    public List<? extends ClassDataReference> getAllClasses() throws IOException;

    @NotNull
    public static ClassProviderRoot ofJdk() throws IOException {
        return SystemClassProviderRoot.newInstance();
    }

    @NotNull
    public static ClassProviderRoot fromDir(@NotNull Path path) {
        return new DirClassProviderRoot(path);
    }

    @NotNull
    public static @NotNull List<@NotNull ClassProviderRoot> fromDirs(Path ... paths) {
        ClassProviderRoot[] roots = new ClassProviderRoot[paths.length];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            roots[i2] = new DirClassProviderRoot(paths[i2]);
        }
        return Arrays.asList(roots);
    }

    @NotNull
    public static ClassProviderRoot fromJar(@NotNull Path path) throws IOException {
        return new JarClassProviderRoot(path);
    }

    @NotNull
    public static @NotNull List<@NotNull ClassProviderRoot> fromJars(Path ... paths) throws IOException {
        ClassProviderRoot[] roots = new ClassProviderRoot[paths.length];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            roots[i2] = new JarClassProviderRoot(paths[i2]);
        }
        return Arrays.asList(roots);
    }

    public static interface ClassDataReference {
        @NotNull
        public String name();

        public byte @Nullable [] readData() throws IOException;
    }
}

