/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

class SystemClassProviderRootJdk9
implements ClassProviderRoot {
    @NotNull
    private final List<ModuleReader> readers;

    SystemClassProviderRootJdk9() throws IOException {
        Set<ModuleReference> refs = ModuleFinder.ofSystem().findAll();
        ModuleReader[] readers = new ModuleReader[refs.size()];
        int index = 0;
        for (ModuleReference ref : refs) {
            readers[index++] = ref.open();
        }
        this.readers = Arrays.asList(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @Nullable [] getClassData(@NotNull String fileName) throws IOException {
        for (ModuleReader reader : this.readers) {
            ByteBuffer resource = reader.read(fileName).orElse(null);
            if (resource == null) continue;
            try {
                byte[] data = new byte[resource.remaining()];
                resource.get(data);
                byte[] byArray2 = data;
                return byArray2;
            }
            finally {
                reader.release(resource);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends ClassProviderRoot.ClassDataReference> getAllClasses() throws IOException {
        List refs = null;
        for (ModuleReader reader : this.readers) {
            List list = reader.list().filter(n -> n.endsWith(".class")).map(n -> new SystemClassDataReference((String)n, reader)).collect(Collectors.toList());
            if (refs == null) {
                refs = list;
                continue;
            }
            refs.addAll(list);
        }
        return refs == null ? Collections.emptyList() : refs;
    }

    @Override
    public void close() throws IOException {
        IOException thrown = null;
        for (ModuleReader reader : this.readers) {
            try {
                reader.close();
            }
            catch (IOException e) {
                thrown = HypoModelUtil.addSuppressed(thrown, e);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    static final class SystemClassDataReference
    implements ClassProviderRoot.ClassDataReference {
        @NotNull
        private final String name;
        @NotNull
        private final ModuleReader reader;

        SystemClassDataReference(@NotNull String name2, @NotNull ModuleReader reader) {
            this.name = name2;
            this.reader = reader;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte @Nullable [] readData() throws IOException {
            ByteBuffer resource = this.reader.read(this.name).orElse(null);
            if (resource == null) {
                return null;
            }
            try {
                byte[] data = new byte[resource.remaining()];
                resource.get(data);
                byte[] byArray2 = data;
                return byArray2;
            }
            finally {
                this.reader.release(resource);
            }
        }
    }
}

