/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.io.IOException;
import java.util.Set;
import paper.libs.dev.denwav.hypo.model.data.AbstractClassData;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.ClassKind;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.LazyValue;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public abstract class LazyClassData
extends AbstractClassData {
    @NotNull
    private final LazyValue<String, ?> name = LazyValue.of(this::computeName);
    @NotNull
    private final LazyValue<ClassData, IOException> outerClass = LazyValue.of(this::computeOuterClass);
    private final LazyValue<Boolean, ?> staticInnerClass = LazyValue.of(this::computeStaticInnerClass);
    private final LazyValue<Boolean, ?> isFinal = LazyValue.of(this::computeIsFinal);
    private final LazyValue<Boolean, ?> isSynthetic = LazyValue.of(this::computeIsSynthetic);
    @NotNull
    private final LazyValue<ClassKind, ?> classKind = LazyValue.of(this::computeClassKind);
    @NotNull
    private final @NotNull LazyValue<@NotNull Visibility, ?> visibility = LazyValue.of(this::computeVisibility);
    @NotNull
    private final LazyValue<ClassData, IOException> superClass = LazyValue.of(this::computeSuperClass);
    @NotNull
    private final LazyValue<Set<ClassData>, IOException> interfaces = LazyValue.of(this::computeInterfaces);
    @NotNull
    private final LazyValue<Set<FieldData>, ?> fields = LazyValue.of(this::computeFields);
    @NotNull
    private final LazyValue<Set<MethodData>, ?> methods = LazyValue.of(this::computeMethods);

    @NotNull
    public abstract String computeName();

    @Nullable
    public abstract ClassData computeOuterClass() throws IOException;

    public abstract boolean computeStaticInnerClass();

    public abstract boolean computeIsFinal();

    public abstract boolean computeIsSynthetic();

    @NotNull
    public abstract ClassKind computeClassKind();

    @NotNull
    public abstract Visibility computeVisibility();

    @Nullable
    public abstract ClassData computeSuperClass() throws IOException;

    @NotNull
    public abstract Set<ClassData> computeInterfaces() throws IOException;

    @NotNull
    public abstract Set<FieldData> computeFields();

    @NotNull
    public abstract Set<MethodData> computeMethods();

    @Override
    @NotNull
    public String name() {
        return this.name.getNotNull();
    }

    @Override
    @Nullable
    public ClassData outerClass() throws IOException {
        return this.outerClass.getOrThrow();
    }

    @Override
    public boolean isStaticInnerClass() {
        return this.staticInnerClass.getNotNull();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal.getNotNull();
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic.getNotNull();
    }

    @Override
    @NotNull
    public ClassKind kind() {
        return this.classKind.getNotNull();
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return this.visibility.getNotNull();
    }

    @Override
    @Nullable
    public ClassData superClass() throws IOException {
        return this.superClass.getOrThrow();
    }

    @Override
    @NotNull
    public Set<ClassData> interfaces() throws IOException {
        return this.interfaces.getOrThrowNotNull();
    }

    @Override
    @NotNull
    public Set<FieldData> fields() {
        return this.fields.getNotNull();
    }

    @Override
    @NotNull
    public Set<MethodData> methods() {
        return this.methods.getNotNull();
    }
}

