/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.io.sigpipe.jbsdiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import paper.libs.io.sigpipe.jbsdiff.ControlBlock;
import paper.libs.io.sigpipe.jbsdiff.DefaultDiffSettings;
import paper.libs.io.sigpipe.jbsdiff.DiffSettings;
import paper.libs.io.sigpipe.jbsdiff.Header;
import paper.libs.io.sigpipe.jbsdiff.InvalidHeaderException;
import paper.libs.io.sigpipe.jbsdiff.sort.SearchResult;
import paper.libs.io.sigpipe.jbsdiff.sort.SuffixSort;
import paper.libs.org.apache.commons.compress.compressors.CompressorException;
import paper.libs.org.apache.commons.compress.compressors.CompressorOutputStream;
import paper.libs.org.apache.commons.compress.compressors.CompressorStreamFactory;

public class Diff {
    public static void diff(byte[] oldBytes, byte[] newBytes, OutputStream out) throws CompressorException, InvalidHeaderException, IOException {
        Diff.diff(oldBytes, newBytes, out, new DefaultDiffSettings());
    }

    public static void diff(byte[] oldBytes, byte[] newBytes, OutputStream out, DiffSettings settings) throws CompressorException, InvalidHeaderException, IOException {
        CompressorStreamFactory compressor = new CompressorStreamFactory();
        String compression = settings.getCompression();
        int[] I = settings.sort(oldBytes);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        CompressorOutputStream patchOut = compressor.createCompressorOutputStream(compression, byteOut);
        SearchResult result2 = null;
        int scan2 = 0;
        int len = 0;
        int position = 0;
        int lastScan = 0;
        int lastPos = 0;
        int lastOffset = 0;
        int oldScore = 0;
        int scsc = 0;
        byte[] db = new byte[newBytes.length + 1];
        byte[] eb = new byte[newBytes.length + 1];
        int dblen = 0;
        int eblen = 0;
        while (scan2 < newBytes.length) {
            oldScore = 0;
            scsc = scan2 += len;
            while (scan2 < newBytes.length) {
                result2 = SuffixSort.search(I, oldBytes, 0, newBytes, scan2, 0, oldBytes.length);
                len = result2.getLength();
                position = result2.getPosition();
                while (scsc < scan2 + len) {
                    if (scsc + lastOffset < oldBytes.length && oldBytes[scsc + lastOffset] == newBytes[scsc]) {
                        ++oldScore;
                    }
                    ++scsc;
                }
                if (len == oldScore && len != 0 || len > oldScore + 8) break;
                if (scan2 + lastOffset < oldBytes.length && oldBytes[scan2 + lastOffset] == newBytes[scan2]) {
                    --oldScore;
                }
                ++scan2;
            }
            if (len == oldScore && scan2 != newBytes.length) continue;
            int s = 0;
            int Sf = 0;
            int lenf = 0;
            int i2 = 0;
            while (lastScan + i2 < scan2 && lastPos + i2 < oldBytes.length) {
                if (oldBytes[lastPos + i2] == newBytes[lastScan + i2]) {
                    ++s;
                }
                if (s * 2 - ++i2 <= Sf * 2 - lenf) continue;
                Sf = s;
                lenf = i2;
            }
            int lenb = 0;
            if (scan2 < newBytes.length) {
                s = 0;
                int Sb = 0;
                for (i2 = 1; scan2 >= lastScan + i2 && position >= i2; ++i2) {
                    if (oldBytes[position - i2] == newBytes[scan2 - i2]) {
                        ++s;
                    }
                    if (s * 2 - i2 <= Sb * 2 - lenb) continue;
                    Sb = s;
                    lenb = i2;
                }
            }
            if (lastScan + lenf > scan2 - lenb) {
                int overlap = lastScan + lenf - (scan2 - lenb);
                s = 0;
                int Ss = 0;
                int lens = 0;
                for (i2 = 0; i2 < overlap; ++i2) {
                    if (newBytes[lastScan + lenf - overlap + i2] == oldBytes[lastPos + lenf - overlap + i2]) {
                        ++s;
                    }
                    if (newBytes[scan2 - lenb + i2] == oldBytes[position - lenb + i2]) {
                        --s;
                    }
                    if (s <= Ss) continue;
                    Ss = s;
                    lens = i2 + 1;
                }
                lenf += lens - overlap;
                lenb -= lens;
            }
            for (i2 = 0; i2 < lenf; ++i2) {
                int n = dblen + i2;
                db[n] = (byte)(db[n] | newBytes[lastScan + i2] - oldBytes[lastPos + i2]);
            }
            for (i2 = 0; i2 < scan2 - lenb - (lastScan + lenf); ++i2) {
                eb[eblen + i2] = newBytes[lastScan + lenf + i2];
            }
            dblen += lenf;
            eblen += scan2 - lenb - (lastScan + lenf);
            ControlBlock control = new ControlBlock();
            control.setDiffLength(lenf);
            control.setExtraLength(scan2 - lenb - (lastScan + lenf));
            control.setSeekLength(position - lenb - (lastPos + lenf));
            control.write(patchOut);
            lastScan = scan2 - lenb;
            lastPos = position - lenb;
            lastOffset = position - scan2;
        }
        patchOut.close();
        Header header = new Header();
        header.setControlLength(byteOut.size());
        patchOut = compressor.createCompressorOutputStream(compression, byteOut);
        patchOut.write(db);
        patchOut.close();
        header.setDiffLength(byteOut.size() - header.getControlLength());
        patchOut = compressor.createCompressorOutputStream(compression, byteOut);
        patchOut.write(eb);
        patchOut.close();
        header.setOutputLength(newBytes.length);
        header.write(out);
        out.write(byteOut.toByteArray());
    }
}

