/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.net.fabricmc.mapping.tree;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import paper.libs.net.fabricmc.mapping.reader.v2.MappingGetter;
import paper.libs.net.fabricmc.mapping.reader.v2.MappingParseException;
import paper.libs.net.fabricmc.mapping.reader.v2.TinyMetadata;
import paper.libs.net.fabricmc.mapping.reader.v2.TinyV2Factory;
import paper.libs.net.fabricmc.mapping.reader.v2.TinyVisitor;
import paper.libs.net.fabricmc.mapping.tree.ClassDef;
import paper.libs.net.fabricmc.mapping.tree.ClassImpl;
import paper.libs.net.fabricmc.mapping.tree.DescriptorMapper;
import paper.libs.net.fabricmc.mapping.tree.EmptyTinyTree;
import paper.libs.net.fabricmc.mapping.tree.FieldImpl;
import paper.libs.net.fabricmc.mapping.tree.LocalVariableImpl;
import paper.libs.net.fabricmc.mapping.tree.MappedImpl;
import paper.libs.net.fabricmc.mapping.tree.MethodImpl;
import paper.libs.net.fabricmc.mapping.tree.ParameterImpl;
import paper.libs.net.fabricmc.mapping.tree.TinyTree;

public final class TinyMappingFactory {
    public static final TinyTree EMPTY_TREE = new EmptyTinyTree();
    public static final TinyMetadata EMPTY_METADATA = new EmptyTinyTree.Metadata();

    public static TinyTree load(BufferedReader reader) throws IOException, MappingParseException {
        return TinyMappingFactory.load(reader, false);
    }

    public static TinyTree load(BufferedReader reader, boolean slim) throws IOException, MappingParseException {
        Visitor visitor = new Visitor(slim);
        TinyV2Factory.visit(reader, visitor);
        return new Tree(visitor.metadata, visitor.classNames, visitor.classes);
    }

    public static TinyTree loadWithDetection(BufferedReader reader) throws IOException, MappingParseException {
        return TinyMappingFactory.loadWithDetection(reader, false);
    }

    public static TinyTree loadWithDetection(BufferedReader reader, boolean slim) throws IOException, MappingParseException {
        reader.mark(8192);
        String firstLine = reader.readLine();
        String[] header = firstLine.split("\t");
        reader.reset();
        switch (header[0]) {
            case "tiny": {
                return TinyMappingFactory.load(reader, slim);
            }
            case "v1": {
                return TinyMappingFactory.loadLegacy(reader);
            }
        }
        throw new UnsupportedOperationException("Unsupported format with header \"" + firstLine + "\"!");
    }

    public static TinyTree loadLegacy(BufferedReader reader) throws IOException {
        ClassImpl parent;
        String className;
        String line;
        String[] header = reader.readLine().split("\t");
        if (header.length <= 1 || !header[0].equals("v1")) {
            throw new IOException("Invalid mapping version!");
        }
        String[] namespaceList = new String[header.length - 1];
        HashMap<String, Integer> namespacesToIds = new HashMap<String, Integer>();
        ToIntFunction<String> namespaceMapper = namespacesToIds::get;
        ArrayList<ClassDef> classEntries = new ArrayList<ClassDef>();
        for (int i2 = 1; i2 < header.length; ++i2) {
            namespaceList[i2 - 1] = header[i2];
            if (namespacesToIds.containsKey(header[i2])) {
                throw new IOException("Duplicate namespace: " + header[i2]);
            }
            namespacesToIds.put(header[i2], i2 - 1);
        }
        HashMap<String, ClassImpl> firstNamespaceClassEntries = new HashMap<String, ClassImpl>();
        ArrayList<String[]> fieldLines = new ArrayList<String[]>();
        ArrayList<String[]> methodLines = new ArrayList<String[]>();
        while ((line = reader.readLine()) != null) {
            String[] splitLine = line.split("\t");
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "CLASS": {
                    ClassImpl entry = new ClassImpl(namespaceMapper, Arrays.copyOfRange(splitLine, 1, splitLine.length));
                    classEntries.add(entry);
                    firstNamespaceClassEntries.put(entry.getName(0), entry);
                    break;
                }
                case "FIELD": {
                    fieldLines.add(splitLine);
                    break;
                }
                case "METHOD": {
                    methodLines.add(splitLine);
                }
            }
        }
        DescriptorMapper mapper = new DescriptorMapper(firstNamespaceClassEntries);
        for (String[] splitLine : fieldLines) {
            className = splitLine[1];
            parent = (ClassImpl)firstNamespaceClassEntries.get(className);
            if (parent == null) {
                parent = new ClassImpl(namespaceMapper, new String[]{className});
                firstNamespaceClassEntries.put(className, parent);
                classEntries.add(parent);
            }
            FieldImpl field = new FieldImpl(mapper, namespaceMapper, Arrays.copyOfRange(splitLine, 3, splitLine.length), splitLine[2]);
            parent.fields.add(field);
        }
        for (String[] splitLine : methodLines) {
            className = splitLine[1];
            parent = (ClassImpl)firstNamespaceClassEntries.get(className);
            if (parent == null) {
                parent = new ClassImpl(namespaceMapper, new String[]{className});
                firstNamespaceClassEntries.put(className, parent);
                classEntries.add(parent);
            }
            MethodImpl method = new MethodImpl(mapper, namespaceMapper, Arrays.copyOfRange(splitLine, 3, splitLine.length), splitLine[2]);
            parent.methods.add(method);
        }
        return new Tree(new LegacyMetadata(Collections.unmodifiableList(Arrays.asList(namespaceList)), namespacesToIds), firstNamespaceClassEntries, classEntries);
    }

    private TinyMappingFactory() {
    }

    private static final class LegacyMetadata
    implements TinyMetadata {
        private final List<String> namespaces;
        private final Map<String, Integer> namespacesToIds;

        LegacyMetadata(List<String> namespaces, Map<String, Integer> namespacesToIds) {
            this.namespaces = namespaces;
            this.namespacesToIds = namespacesToIds;
        }

        @Override
        public int getMajorVersion() {
            return 1;
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public List<String> getNamespaces() {
            return this.namespaces;
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        @Override
        public int index(String namespace) {
            return this.namespacesToIds.getOrDefault(namespace, -1);
        }
    }

    private static final class Tree
    implements TinyTree {
        private final TinyMetadata metadata;
        private final Map<String, ClassDef> map;
        private final Collection<ClassDef> classes;

        Tree(TinyMetadata metadata, Map<String, ClassImpl> map2, Collection<ClassDef> classes) {
            this.metadata = metadata;
            this.map = map2;
            this.classes = classes;
        }

        @Override
        public TinyMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public Map<String, ClassDef> getDefaultNamespaceClassMap() {
            return this.map;
        }

        @Override
        public Collection<ClassDef> getClasses() {
            return this.classes;
        }
    }

    private static final class Visitor
    implements TinyVisitor {
        private static final MappedImpl SLIM_DUMMY = new MappedImpl(s -> 0, new String[0]){};
        private final boolean slim;
        private @MonotonicNonNull TinyMetadata metadata;
        private @MonotonicNonNull ToIntFunction<String> namespaceMapper;
        private final Map<String, ClassImpl> classNames = new HashMap<String, ClassImpl>();
        private final Collection<ClassDef> classes = new ArrayList<ClassDef>();
        private final DescriptorMapper descriptorMapper = new DescriptorMapper(this.classNames);
        private final Deque<MappedImpl> stack = new ArrayDeque<MappedImpl>(4);
        private boolean pushedComment = false;
        private @MonotonicNonNull ClassImpl inClass = null;
        private @MonotonicNonNull MethodImpl inMethod = null;

        Visitor(boolean slim) {
            this.slim = slim;
        }

        @Override
        public void start(TinyMetadata metadata) {
            this.metadata = metadata;
            this.namespaceMapper = metadata::index;
        }

        @Override
        public void pushClass(MappingGetter name2) {
            ClassImpl clz = new ClassImpl(this.namespaceMapper, name2.getRawNames());
            this.classes.add(clz);
            this.classNames.put(name2.get(0), clz);
            this.inClass = clz;
            this.stack.addLast(clz);
        }

        @Override
        public void pushField(MappingGetter name2, String descriptor) {
            if (this.inClass == null) {
                throw new IllegalStateException();
            }
            FieldImpl field = new FieldImpl(this.descriptorMapper, this.namespaceMapper, name2.getRawNames(), descriptor);
            this.inClass.fields.add(field);
            this.stack.addLast(field);
        }

        @Override
        public void pushMethod(MappingGetter name2, String descriptor) {
            if (this.inClass == null) {
                throw new IllegalStateException();
            }
            MethodImpl method = new MethodImpl(this.descriptorMapper, this.namespaceMapper, name2.getRawNames(), descriptor);
            this.inClass.methods.add(method);
            this.inMethod = method;
            this.stack.addLast(method);
        }

        @Override
        public void pushParameter(MappingGetter name2, int localVariableIndex) {
            if (this.inMethod == null) {
                throw new IllegalStateException();
            }
            if (this.slim) {
                this.stack.addLast(SLIM_DUMMY);
                return;
            }
            ParameterImpl par = new ParameterImpl(this.namespaceMapper, name2.getRawNames(), localVariableIndex);
            this.inMethod.parameters.add(par);
            this.stack.addLast(par);
        }

        @Override
        public void pushLocalVariable(MappingGetter name2, int localVariableIndex, int localVariableStartOffset, int localVariableTableIndex) {
            if (this.inMethod == null) {
                throw new IllegalStateException();
            }
            if (this.slim) {
                this.stack.addLast(SLIM_DUMMY);
                return;
            }
            LocalVariableImpl var = new LocalVariableImpl(this.namespaceMapper, name2.getRawNames(), localVariableIndex, localVariableStartOffset, localVariableTableIndex);
            this.inMethod.localVariables.add(var);
            this.stack.addLast(var);
        }

        @Override
        public void pushComment(String comment) {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Nothing to append comment on!");
            }
            if (this.pushedComment) {
                throw new IllegalStateException("Commenting on a comment!");
            }
            if (!this.slim) {
                this.stack.peekLast().setComment(comment);
            }
            this.pushedComment = true;
        }

        @Override
        public void pop(int count2) {
            if (this.pushedComment) {
                this.pushedComment = false;
                --count2;
            }
            for (int i2 = 0; i2 < count2; ++i2) {
                this.stack.removeLast();
            }
        }
    }
}

