/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.commons.compress.archivers.ar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import paper.libs.org.apache.commons.compress.archivers.ArchiveEntry;
import paper.libs.org.apache.commons.compress.archivers.ArchiveInputStream;
import paper.libs.org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import paper.libs.org.apache.commons.compress.utils.ArchiveUtils;

public class ArArchiveInputStream
extends ArchiveInputStream {
    private final InputStream input;
    private long offset = 0L;
    private boolean closed;
    private ArArchiveEntry currentEntry = null;
    private byte[] namebuffer = null;
    private long entryOffset = -1L;
    private final byte[] NAME_BUF = new byte[16];
    private final byte[] LAST_MODIFIED_BUF = new byte[12];
    private final byte[] ID_BUF = new byte[6];
    private final byte[] FILE_MODE_BUF = new byte[8];
    private final byte[] LENGTH_BUF = new byte[10];
    static final String BSD_LONGNAME_PREFIX = "#1/";
    private static final int BSD_LONGNAME_PREFIX_LEN = "#1/".length();
    private static final String BSD_LONGNAME_PATTERN = "^#1/\\d+";
    private static final String GNU_STRING_TABLE_NAME = "//";
    private static final String GNU_LONGNAME_PATTERN = "^/\\d+";

    public ArArchiveInputStream(InputStream pInput) {
        this.input = pInput;
        this.closed = false;
    }

    public ArArchiveEntry getNextArEntry() throws IOException {
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            while (this.offset < entryEnd) {
                int x = this.read();
                if (x != -1) continue;
                return null;
            }
            this.currentEntry = null;
        }
        if (this.offset == 0L) {
            byte[] expected = ArchiveUtils.toAsciiBytes("!<arch>\n");
            byte[] realized = new byte[expected.length];
            int read = this.read(realized);
            if (read != expected.length) {
                throw new IOException("failed to read header. Occured at byte: " + this.getBytesRead());
            }
            for (int i2 = 0; i2 < expected.length; ++i2) {
                if (expected[i2] == realized[i2]) continue;
                throw new IOException("invalid header " + ArchiveUtils.toAsciiString(realized));
            }
        }
        if (this.offset % 2L != 0L && this.read() < 0) {
            return null;
        }
        if (this.input.available() == 0) {
            return null;
        }
        this.read(this.NAME_BUF);
        this.read(this.LAST_MODIFIED_BUF);
        this.read(this.ID_BUF);
        int userId = this.asInt(this.ID_BUF, true);
        this.read(this.ID_BUF);
        this.read(this.FILE_MODE_BUF);
        this.read(this.LENGTH_BUF);
        byte[] expected = ArchiveUtils.toAsciiBytes("`\n");
        byte[] realized = new byte[expected.length];
        int read = this.read(realized);
        if (read != expected.length) {
            throw new IOException("failed to read entry trailer. Occured at byte: " + this.getBytesRead());
        }
        for (int i3 = 0; i3 < expected.length; ++i3) {
            if (expected[i3] == realized[i3]) continue;
            throw new IOException("invalid entry trailer. not read the content? Occured at byte: " + this.getBytesRead());
        }
        this.entryOffset = this.offset;
        String temp = ArchiveUtils.toAsciiString(this.NAME_BUF).trim();
        if (ArArchiveInputStream.isGNUStringTable(temp)) {
            this.currentEntry = this.readGNUStringTable(this.LENGTH_BUF);
            return this.getNextArEntry();
        }
        long len = this.asLong(this.LENGTH_BUF);
        if (temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        } else if (this.isGNULongName(temp)) {
            int offset = Integer.parseInt(temp.substring(1));
            temp = this.getExtendedName(offset);
        } else if (ArArchiveInputStream.isBSDLongName(temp)) {
            temp = this.getBSDLongName(temp);
            int nameLen = temp.length();
            len -= (long)nameLen;
            this.entryOffset += (long)nameLen;
        }
        this.currentEntry = new ArArchiveEntry(temp, len, userId, this.asInt(this.ID_BUF, true), this.asInt(this.FILE_MODE_BUF, 8), this.asLong(this.LAST_MODIFIED_BUF));
        return this.currentEntry;
    }

    private String getExtendedName(int offset) throws IOException {
        if (this.namebuffer == null) {
            throw new IOException("Cannot process GNU long filename as no // record was found");
        }
        for (int i2 = offset; i2 < this.namebuffer.length; ++i2) {
            if (this.namebuffer[i2] != 10) continue;
            if (this.namebuffer[i2 - 1] == 47) {
                --i2;
            }
            return ArchiveUtils.toAsciiString(this.namebuffer, offset, i2 - offset);
        }
        throw new IOException("Failed to read entry: " + offset);
    }

    private long asLong(byte[] input) {
        return Long.parseLong(ArchiveUtils.toAsciiString(input).trim());
    }

    private int asInt(byte[] input) {
        return this.asInt(input, 10, false);
    }

    private int asInt(byte[] input, boolean treatBlankAsZero) {
        return this.asInt(input, 10, treatBlankAsZero);
    }

    private int asInt(byte[] input, int base) {
        return this.asInt(input, base, false);
    }

    private int asInt(byte[] input, int base, boolean treatBlankAsZero) {
        String string = ArchiveUtils.toAsciiString(input).trim();
        if (string.length() == 0 && treatBlankAsZero) {
            return 0;
        }
        return Integer.parseInt(string, base);
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextArEntry();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
        this.currentEntry = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        if (this.currentEntry != null) {
            long entryEnd = this.entryOffset + this.currentEntry.getLength();
            if (len > 0 && entryEnd > this.offset) {
                toRead = (int)Math.min((long)len, entryEnd - this.offset);
            } else {
                return -1;
            }
        }
        int ret2 = this.input.read(b, off, toRead);
        this.count(ret2);
        this.offset += (long)(ret2 > 0 ? ret2 : 0);
        return ret2;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 8) {
            return false;
        }
        if (signature[0] != 33) {
            return false;
        }
        if (signature[1] != 60) {
            return false;
        }
        if (signature[2] != 97) {
            return false;
        }
        if (signature[3] != 114) {
            return false;
        }
        if (signature[4] != 99) {
            return false;
        }
        if (signature[5] != 104) {
            return false;
        }
        if (signature[6] != 62) {
            return false;
        }
        return signature[7] == 10;
    }

    private static boolean isBSDLongName(String name2) {
        return name2 != null && name2.matches(BSD_LONGNAME_PATTERN);
    }

    private String getBSDLongName(String bsdLongName) throws IOException {
        int nameLen = Integer.parseInt(bsdLongName.substring(BSD_LONGNAME_PREFIX_LEN));
        byte[] name2 = new byte[nameLen];
        int read = 0;
        int readNow = 0;
        while ((readNow = this.input.read(name2, read, nameLen - read)) >= 0) {
            this.count(readNow);
            if ((read += readNow) != nameLen) continue;
        }
        if (read != nameLen) {
            throw new EOFException();
        }
        return ArchiveUtils.toAsciiString(name2);
    }

    private static boolean isGNUStringTable(String name2) {
        return GNU_STRING_TABLE_NAME.equals(name2);
    }

    private ArArchiveEntry readGNUStringTable(byte[] length) throws IOException {
        int bufflen = this.asInt(length);
        this.namebuffer = new byte[bufflen];
        int read = this.read(this.namebuffer, 0, bufflen);
        if (read != bufflen) {
            throw new IOException("Failed to read complete // record: expected=" + bufflen + " read=" + read);
        }
        return new ArArchiveEntry(GNU_STRING_TABLE_NAME, bufflen);
    }

    private boolean isGNULongName(String name2) {
        return name2 != null && name2.matches(GNU_LONGNAME_PATTERN);
    }
}

