/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import paper.libs.org.apache.http.HttpConnection;
import paper.libs.org.apache.http.HttpException;
import paper.libs.org.apache.http.HttpHost;
import paper.libs.org.apache.http.HttpInetConnection;
import paper.libs.org.apache.http.HttpRequest;
import paper.libs.org.apache.http.HttpRequestInterceptor;
import paper.libs.org.apache.http.HttpVersion;
import paper.libs.org.apache.http.ProtocolException;
import paper.libs.org.apache.http.ProtocolVersion;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.protocol.HttpContext;
import paper.libs.org.apache.http.protocol.HttpCoreContext;
import paper.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

