/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.asm.jar;

import java.util.List;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import paper.libs.org.cadixdev.bombe.jar.JarClassEntry;
import paper.libs.org.cadixdev.bombe.jar.JarEntryTransformer;
import paper.libs.org.cadixdev.bombe.jar.JarManifestEntry;
import paper.libs.org.cadixdev.bombe.jar.JarServiceProviderConfigurationEntry;
import paper.libs.org.cadixdev.bombe.jar.ServiceProviderConfiguration;
import paper.libs.org.objectweb.asm.ClassReader;
import paper.libs.org.objectweb.asm.ClassVisitor;
import paper.libs.org.objectweb.asm.ClassWriter;
import paper.libs.org.objectweb.asm.commons.ClassRemapper;
import paper.libs.org.objectweb.asm.commons.Remapper;

public class JarEntryRemappingTransformer
implements JarEntryTransformer {
    private final Remapper remapper;
    private final BiFunction<ClassVisitor, Remapper, ClassRemapper> clsRemapper;

    public JarEntryRemappingTransformer(Remapper remapper, BiFunction<ClassVisitor, Remapper, ClassRemapper> clsRemapper) {
        this.remapper = remapper;
        this.clsRemapper = clsRemapper;
    }

    public JarEntryRemappingTransformer(Remapper remapper) {
        this(remapper, ClassRemapper::new);
    }

    @Override
    public JarClassEntry transform(JarClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getContents());
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept(this.clsRemapper.apply(writer, this.remapper), 0);
        String originalName = entry.getName().substring(0, entry.getName().length() - ".class".length());
        String name2 = this.remapper.map(originalName) + ".class";
        return new JarClassEntry(name2, entry.getTime(), writer.toByteArray());
    }

    @Override
    public JarManifestEntry transform(JarManifestEntry entry) {
        if (entry.getManifest().getMainAttributes().containsKey(new Attributes.Name("Main-Class"))) {
            String mainClassObf = entry.getManifest().getMainAttributes().getValue("Main-Class").replace('.', '/');
            String mainClassDeobf = this.remapper.map(mainClassObf).replace('/', '.');
            entry.getManifest().getMainAttributes().putValue("Main-Class", mainClassDeobf);
        }
        return entry;
    }

    @Override
    public JarServiceProviderConfigurationEntry transform(JarServiceProviderConfigurationEntry entry) {
        String obfServiceName = entry.getConfig().getService().replace('.', '/');
        String deobfServiceName = this.remapper.map(obfServiceName).replace('/', '.');
        List<String> deobfProviders = entry.getConfig().getProviders().stream().map(provider -> provider.replace('.', '/')).map(this.remapper::map).map(provider -> provider.replace('/', '.')).collect(Collectors.toList());
        ServiceProviderConfiguration config = new ServiceProviderConfiguration(deobfServiceName, deobfProviders);
        return new JarServiceProviderConfigurationEntry(entry.getTime(), config);
    }
}

