/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.io.proguard;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.bombe.type.MethodDescriptor;
import paper.libs.org.cadixdev.bombe.type.Type;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.TextMappingsReader;
import paper.libs.org.cadixdev.lorenz.io.proguard.PGTypeReader;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;

public class ProGuardReader
extends TextMappingsReader {
    public ProGuardReader(Reader reader) {
        super(reader, Processor::new);
    }

    public static class Processor
    extends TextMappingsReader.Processor {
        private ClassMapping<?, ?> currentClass;

        public Processor(MappingSet mappings) {
            super(mappings);
        }

        @Override
        public void accept(String raw) {
            if (raw.startsWith("#")) {
                return;
            }
            String[] params = raw.trim().split(" ");
            if (params.length == 3 && params[1].equals("->")) {
                String obf = params[0].replace('.', '/');
                String deobf = params[2].substring(0, params[2].length() - 1).replace('.', '/');
                this.currentClass = (ClassMapping)this.mappings.getOrCreateClassMapping(obf).setDeobfuscatedName(deobf);
            }
            if (params.length == 4 && params[2].equals("->")) {
                String returnTypeRaw = params[0];
                String obf = params[1];
                String deobf = params[3];
                if (obf.contains("(")) {
                    int index = returnTypeRaw.lastIndexOf(58);
                    String returnCleanRaw = index != -1 ? returnTypeRaw.substring(index + 1) : returnTypeRaw;
                    Type returnClean = new PGTypeReader(returnCleanRaw).readType();
                    String obfName = obf.substring(0, obf.indexOf(40));
                    String[] obfParams = obf.substring(obf.indexOf(40) + 1, obf.length() - 1).split(",");
                    List<FieldType> paramTypes = Arrays.stream(obfParams).filter(line -> !line.isEmpty()).map(PGTypeReader::new).map(PGTypeReader::readFieldType).collect(Collectors.toList());
                    this.currentClass.getOrCreateMethodMapping(obfName, new MethodDescriptor(paramTypes, returnClean)).setDeobfuscatedName(deobf);
                } else {
                    FieldSignature fieldSignature = new FieldSignature(obf, new PGTypeReader(returnTypeRaw).readFieldType());
                    this.currentClass.getOrCreateFieldMapping(fieldSignature).setDeobfuscatedName(deobf);
                }
            }
        }
    }
}

