/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.util.AsmUtil;
import io.papermc.paperweight.util.ClassNodeCache;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.AbstractInsnNode;
import paper.libs.org.objectweb.asm.tree.ClassNode;
import paper.libs.org.objectweb.asm.tree.FieldInsnNode;
import paper.libs.org.objectweb.asm.tree.FieldNode;
import paper.libs.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/papermc/paperweight/tasks/FieldAccessNormalizer;", "Lio/papermc/paperweight/util/AsmUtil;", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "<init>", "(Lorg/objectweb/asm/tree/ClassNode;Lio/papermc/paperweight/util/ClassNodeCache;)V", "visitNode", "", "visitMethod", "method", "Lpaper/libs/org/objectweb/asm/tree/MethodNode;", "visitFieldInst", "instruction", "Lpaper/libs/org/objectweb/asm/tree/FieldInsnNode;", "findTargetFieldDeclaration", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nFixJarForReobf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixJarForReobf.kt\nio/papermc/paperweight/tasks/FieldAccessNormalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n295#2,2:229\n*S KotlinDebug\n*F\n+ 1 FixJarForReobf.kt\nio/papermc/paperweight/tasks/FieldAccessNormalizer\n*L\n179#1:229,2\n*E\n"})
public final class FieldAccessNormalizer
implements AsmUtil {
    @NotNull
    private final ClassNode node;
    @NotNull
    private final ClassNodeCache classNodeCache;

    public FieldAccessNormalizer(@NotNull ClassNode node, @NotNull ClassNodeCache classNodeCache) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)classNodeCache, (String)"classNodeCache");
        this.node = node;
        this.classNodeCache = classNodeCache;
    }

    public final void visitNode() {
        for (MethodNode method : this.node.methods) {
            Intrinsics.checkNotNull((Object)method);
            this.visitMethod(method);
        }
    }

    private final void visitMethod(MethodNode method) {
        Iterator iterator = method.instructions.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            FieldInsnNode fieldInst;
            AbstractInsnNode instruction = (AbstractInsnNode)iterator2.next();
            if ((instruction instanceof FieldInsnNode ? (FieldInsnNode)instruction : null) == null) continue;
            fieldInst = fieldInst;
            this.visitFieldInst(fieldInst);
        }
    }

    private final void visitFieldInst(FieldInsnNode instruction) {
        ClassNode classNode = this.findTargetFieldDeclaration(instruction);
        if (classNode == null) {
            return;
        }
        ClassNode ownerNode = classNode;
        instruction.owner = ownerNode.name;
    }

    private final ClassNode findTargetFieldDeclaration(FieldInsnNode instruction) {
        String fieldName = instruction.name;
        String className = instruction.owner;
        while (className != null) {
            Object v1;
            ClassNode currentNode;
            block13: {
                if (this.classNodeCache.findClass(className) == null) {
                    return null;
                }
                List<FieldNode> list = currentNode.fields;
                Intrinsics.checkNotNullExpressionValue(list, (String)"fields");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FieldNode it = (FieldNode)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name, (Object)fieldName)) continue;
                    v1 = element$iv;
                    break block13;
                }
                v1 = null;
            }
            FieldNode fieldNode = v1;
            if (fieldNode != null) {
                if (this.contains(fieldNode.access, 2)) {
                    if (Intrinsics.areEqual((Object)currentNode.name, (Object)this.node.name)) {
                        return currentNode;
                    }
                } else if (this.contains(fieldNode.access, 4)) {
                    ClassNode walkingNode = this.node;
                    while (walkingNode != null) {
                        if (Intrinsics.areEqual((Object)walkingNode.name, (Object)currentNode.name)) {
                            return currentNode;
                        }
                        walkingNode = this.classNodeCache.findClass(walkingNode.superName);
                    }
                } else {
                    if (this.contains(fieldNode.access, 1)) {
                        return currentNode;
                    }
                    String string = currentNode.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    String currentPackage = StringsKt.substringBeforeLast$default((String)string, (char)'/', null, (int)2, null);
                    String string2 = this.node.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                    String originalPackage = StringsKt.substringBeforeLast$default((String)string2, (char)'/', null, (int)2, null);
                    if (Intrinsics.areEqual((Object)currentPackage, (Object)originalPackage)) {
                        return currentNode;
                    }
                }
            }
            className = currentNode.superName;
        }
        return null;
    }
}

