/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.ControllableOutputTask;
import io.papermc.paperweight.tasks.RebuildGitPatches;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import paper.libs.org.jetbrains.annotations.NotNull;

@UntrackedTask(because="RebuildGitPatches should always run when requested")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lio/papermc/paperweight/tasks/RebuildGitPatches;", "Lio/papermc/paperweight/tasks/ControllableOutputTask;", "<init>", "()V", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "baseRef", "Lorg/gradle/api/provider/Property;", "", "getBaseRef", "()Lorg/gradle/api/provider/Property;", "patchDir", "getPatchDir", "filterPatches", "", "getFilterPatches", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "init", "", "run", "cleanupPatches", "git", "Lio/papermc/paperweight/util/Git;", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nRebuildGitPatches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RebuildGitPatches.kt\nio/papermc/paperweight/tasks/RebuildGitPatches\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n1#2:165\n1869#3,2:166\n1563#3:168\n1634#3,3:169\n1563#3:176\n1634#3,3:177\n37#4:172\n36#4,3:173\n37#4:180\n36#4,3:181\n*S KotlinDebug\n*F\n+ 1 RebuildGitPatches.kt\nio/papermc/paperweight/tasks/RebuildGitPatches\n*L\n145#1:166,2\n152#1:168\n152#1:169,3\n153#1:176\n153#1:177,3\n152#1:172\n152#1:173,3\n153#1:180\n153#1:181,3\n*E\n"})
public abstract class RebuildGitPatches
extends ControllableOutputTask {
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @Input
    @NotNull
    public abstract Property<String> getBaseRef();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getFilterPatches();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Override
    public void init() {
        this.getPrintOutput().convention((Object)true);
        this.getFilterPatches().convention(this.getProviders().gradleProperty("paperweight.filter-patches").map((Transformer)init.1.INSTANCE).orElse((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Iterable orderedFiles;
        String what = PathsKt.getName((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())));
        Path patchFolder = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(patchFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(patchFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        if (((Boolean)this.getPrintOutput().get()).booleanValue()) {
            this.getLogger().lifecycle("Formatting patches for " + what + "...");
        }
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            if (((Boolean)this.getPrintOutput().get()).booleanValue()) {
                Iterable iterable;
                this.getLogger().lifecycle("REBASE DETECTED - PARTIAL SAVE");
                Path path3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply/last");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                int last2 = Integer.parseInt(((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path3, null, (int)1, null))).toString());
                Path path4 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply/next");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                int next = Integer.parseInt(((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path4, null, (int)1, null))).toString());
                Path path5 = patchFolder;
                Closeable closeable = Files.newDirectoryStream(path5, "*.patch");
                Throwable throwable = null;
                try {
                    iterable = (DirectoryStream)closeable;
                    Intrinsics.checkNotNull((Object)iterable);
                    Sequence it = CollectionsKt.asSequence((Iterable)iterable);
                    boolean bl = false;
                    iterable = SequencesKt.toMutableList((Sequence)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                orderedFiles = iterable;
                CollectionsKt.sort((List)orderedFiles);
                int i2 = 1;
                if (i2 <= last2) {
                    while (true) {
                        if (i2 < next) {
                            FileKt.deleteForcefully((Path)orderedFiles.get(i2));
                        }
                        if (i2 == last2) break;
                        ++i2;
                    }
                }
            }
            v5 = Unit.INSTANCE;
        } else {
            FileKt.deleteRecursive$default(patchFolder, null, null, 3, null);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path6 = Files.createDirectories(patchFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            v5 = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"createDirectories(...)");
        }
        Git git = new Git(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())), null, 2, null);
        String[] next = new String[]{"fetch", "--all", "--prune", "--no-prune-tags"};
        Command.runSilently$default(git.invoke(next), false, true, 1, null);
        next = new String[10];
        next[0] = "format-patch";
        next[1] = "--diff-algorithm=myers";
        next[2] = "--zero-commit";
        next[3] = "--full-index";
        next[4] = "--no-signature";
        next[5] = "--no-stat";
        next[6] = "-N";
        next[7] = "-o";
        next[8] = ((Object)patchFolder.toAbsolutePath()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)this.getBaseRef().get(), (String)"get(...)");
        Command.executeSilently$default(git.invoke(next), false, false, 3, null);
        Git patchDirGit = new Git(patchFolder, null, 2, null);
        orderedFiles = new String[]{"add", "-A", "."};
        Command.executeSilently$default(patchDirGit.invoke((String)((Object)orderedFiles)), false, false, 3, null);
        if (((Boolean)this.getFilterPatches().get()).booleanValue()) {
            this.cleanupPatches(patchDirGit);
        } else if (((Boolean)this.getPrintOutput().get()).booleanValue()) {
            int saved = PathsKt.listDirectoryEntries((Path)patchFolder, (String)"*.patch").size();
            Logger logger = this.getLogger();
            Directory directory = this.getLayout().getProjectDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"getProjectDirectory(...)");
            logger.lifecycle("Saved " + saved + " patches for " + what + " to " + FileKt.getPath((FileSystemLocation)directory).relativize(patchFolder) + "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupPatches(Git git) {
        SpreadBuilder spreadBuilder;
        Iterable iterable;
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
        Closeable closeable = Files.newDirectoryStream(path, "*.patch");
        Object object = null;
        try {
            iterable = (DirectoryStream)closeable;
            Intrinsics.checkNotNull((Object)iterable);
            Sequence it = CollectionsKt.asSequence((Iterable)iterable);
            boolean bl = false;
            iterable = SequencesKt.toMutableList((Sequence)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Iterable patchFiles = iterable;
        if (patchFiles.isEmpty()) {
            return;
        }
        CollectionsKt.sort(patchFiles);
        ConcurrentLinkedQueue<Path> noChangesPatches = new ConcurrentLinkedQueue<Path>();
        List futures = new ArrayList();
        ExecutorService executor = Executors.newWorkStealingPool();
        try {
            for (Path patch : patchFiles) {
                ((Collection)futures).add(executor.submit(new Runnable(git, patch, noChangesPatches){
                    final /* synthetic */ Git $git;
                    final /* synthetic */ Path $patch;
                    final /* synthetic */ ConcurrentLinkedQueue<Path> $noChangesPatches;
                    {
                        this.$git = $git;
                        this.$patch = $patch;
                        this.$noChangesPatches = $noChangesPatches;
                    }

                    public final void run() {
                        boolean hasNoChanges;
                        block2: {
                            boolean bl;
                            String[] stringArray = new String[]{"diff", "--diff-algorithm=myers", "--staged", PathsKt.getName((Path)this.$patch)};
                            Sequence $this$all$iv = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)this.$git.invoke(stringArray).getText()), cleanupPatches.1::run$lambda$0), cleanupPatches.1::run$lambda$1);
                            boolean $i$f$all = false;
                            for (E element$iv : $this$all$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (StringsKt.startsWith$default((String)it, (String)"+index", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-index", (boolean)false, (int)2, null)) continue;
                                bl = false;
                                break block2;
                            }
                            bl = hasNoChanges = true;
                        }
                        if (hasNoChanges) {
                            this.$noChangesPatches.add(this.$patch);
                        }
                    }

                    private static final boolean run$lambda$0(String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return StringsKt.startsWith$default((CharSequence)it, (char)'+', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)it, (char)'-', (boolean)false, (int)2, null);
                    }

                    private static final boolean run$lambda$1(String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return StringsKt.startsWith$default((String)it, (String)"+++", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"---", (boolean)false, (int)2, null);
                    }
                }));
            }
            Iterable $this$forEach$iv = futures;
            boolean $i$f$forEach = false;
            spreadBuilder = $this$forEach$iv.iterator();
            while (spreadBuilder.hasNext()) {
                Object element$iv = spreadBuilder.next();
                Future it = (Future)element$iv;
                boolean bl = false;
                it.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
        if (!((Collection)noChangesPatches).isEmpty()) {
            for (List chunk : CollectionsKt.chunked((Iterable)noChangesPatches, (int)50)) {
                Iterable $this$toTypedArray$iv;
                Path it;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Collection<String> $this$map$iv;
                spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"reset");
                spreadBuilder.add((Object)"HEAD");
                Iterable element$iv = chunk;
                SpreadBuilder spreadBuilder2 = spreadBuilder;
                Git git2 = git;
                boolean $i$f$map = false;
                void bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path2 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(PathsKt.getName((Path)it));
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                Iterable thisCollection$iv = $this$toTypedArray$iv;
                spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                Command.executeSilently$default(git2.invoke((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), false, false, 3, null);
                spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"checkout");
                spreadBuilder.add((Object)"--");
                $this$toTypedArray$iv = chunk;
                spreadBuilder2 = spreadBuilder;
                git2 = git;
                $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(PathsKt.getName((Path)it));
                }
                $this$map$iv = collection = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                Command.executeSilently$default(git2.invoke((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), false, false, 3, null);
            }
        }
        if (((Boolean)this.getPrintOutput().get()).booleanValue()) {
            int saved = patchFiles.size() - noChangesPatches.size();
            Directory directory = this.getLayout().getProjectDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"getProjectDirectory(...)");
            Path relDir = FileKt.getPath((FileSystemLocation)directory).relativize(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir())));
            this.getLogger().lifecycle("Saved modified patches (" + saved + "/" + patchFiles.size() + ") for " + PathsKt.getName((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir()))) + " to " + relDir + "/");
        }
    }
}

