/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lio/papermc/paperweight/tasks/UnpackSpigotBuildData;", "Lio/papermc/paperweight/tasks/BaseTask;", "<init>", "()V", "buildDataZip", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildDataZip", "()Lorg/gradle/api/file/RegularFileProperty;", "buildDataInfoFile", "getBuildDataInfoFile", "excludesFile", "getExcludesFile", "atFile", "getAtFile", "classMappings", "getClassMappings", "specialSourceJar", "getSpecialSourceJar", "specialSource2Jar", "getSpecialSource2Jar", "init", "", "run", "bukkitFileFrom", "Ljava/nio/file/Path;", "dir", "extension", "", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nUnpackSpigotBuildData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpackSpigotBuildData.kt\nio/papermc/paperweight/tasks/UnpackSpigotBuildData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public abstract class UnpackSpigotBuildData
extends BaseTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildDataZip();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBuildDataInfoFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getExcludesFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAtFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getClassMappings();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSpecialSourceJar();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSpecialSource2Jar();

    @Override
    public void init() {
        this.getBuildDataInfoFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-build-data-info", "json"));
        this.getExcludesFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-excludes", "exclude"));
        this.getAtFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-ats", "at"));
        this.getClassMappings().convention((Provider)UtilsKt.defaultOutput(this, "spigot-class-mapping", "csrg"));
        this.getSpecialSourceJar().convention((Provider)UtilsKt.defaultOutput(this, "special-source", "jar"));
        this.getSpecialSource2Jar().convention((Provider)UtilsKt.defaultOutput(this, "special-source-2", "jar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBuildDataZip())));
        Throwable throwable = null;
        try {
            FileSystem it = (FileSystem)closeable;
            boolean bl = false;
            Path root = it.getPath("/", new String[0]);
            Path path = root.resolve("info.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path;
            Path path3 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBuildDataInfoFile())), (FileAttribute[])new FileAttribute[0]);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
            Path mappings = root.resolve("mappings");
            Intrinsics.checkNotNull((Object)mappings);
            path3 = this.bukkitFileFrom(mappings, "exclude");
            Path path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getExcludesFile())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            path3 = this.bukkitFileFrom(mappings, "at");
            path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getAtFile())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            path3 = this.bukkitFileFrom(mappings, "csrg");
            path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getClassMappings())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            Path path5 = root.resolve("bin/SpecialSource.jar");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            path3 = path5;
            path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpecialSourceJar())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            Path path6 = root.resolve("bin/SpecialSource-2.jar");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            path3 = path6;
            path4 = PathsKt.createParentDirectories((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpecialSource2Jar())), (FileAttribute[])new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Path path7 = Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"copy(...)");
            Path path8 = path7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path bukkitFileFrom(Path dir, String extension) {
        Iterable iterable;
        Path path = dir;
        Closeable closeable = Files.newDirectoryStream(path, "*");
        Throwable throwable = null;
        try {
            iterable = (DirectoryStream)closeable;
            Intrinsics.checkNotNull((Object)iterable);
            Sequence it = CollectionsKt.asSequence((Iterable)iterable);
            boolean bl = false;
            iterable = (Path)SequencesKt.single((Sequence)SequencesKt.filter((Sequence)it, arg_0 -> UnpackSpigotBuildData.bukkitFileFrom$lambda$2$lambda$1(extension, arg_0)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return iterable;
    }

    private static final boolean bukkitFileFrom$lambda$2$lambda$1(String $extension, Path f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return StringsKt.endsWith$default((String)PathsKt.getName((Path)f), (String)$extension, (boolean)false, (int)2, null);
    }
}

