/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.action;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.userdev.internal.action.FileSystemLocationOutputValue;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcherImpl;
import io.papermc.paperweight.userdev.internal.action.WorkGraph;
import io.papermc.paperweight.util.File_lockKt;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.InputStreamProvider;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0003*+,BC\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0015\u001a\u00020\bH\u0002J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\r2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002J$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001dJ\\\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\b0\u00182\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001d2\b\b\u0002\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\r*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\r2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\b0\u0018H\u0002J \u0010(\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\bH\u0002R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkGraph;", "", "provided", "", "Lio/papermc/paperweight/userdev/internal/action/Value;", "registrations", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;", "terminalInputHash", "", "requested", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/lang/String;Ljava/util/Set;)V", "roots", "", "Lio/papermc/paperweight/userdev/internal/action/WorkGraph$Node;", "printGraph", "", "Lorg/gradle/api/logging/Logger;", "level", "Lorg/gradle/api/logging/LogLevel;", "nodes", "indent", "buildGraph", "nodeCache", "", "execute", "work", "Ljava/nio/file/Path;", "progressEventListener", "Lkotlin/Function1;", "executeNode", "node", "visited", "", "hashCache", "retry", "", "collectDependencies", "hash", "cache", "realizeOutputPaths", "inputHash", "Companion", "Node", "Metadata", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nWorkGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkGraph.kt\nio/papermc/paperweight/userdev/internal/action/WorkGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n774#2:236\n865#2,2:237\n1869#2,2:239\n1761#2,3:241\n1563#2:244\n1634#2,3:245\n1563#2:248\n1634#2,3:249\n1869#2,2:253\n1#3:252\n*S KotlinDebug\n*F\n+ 1 WorkGraph.kt\nio/papermc/paperweight/userdev/internal/action/WorkGraph\n*L\n74#1:236\n74#1:237,2\n84#1:239,2\n124#1:241,3\n145#1:244\n145#1:245,3\n219#1:248\n219#1:249,3\n167#1:253,2\n*E\n"})
public final class WorkGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Value<?>> provided;
    @NotNull
    private final Set<WorkDispatcherImpl.Registration> registrations;
    @Nullable
    private final String terminalInputHash;
    @NotNull
    private final Set<Value<?>> requested;
    @NotNull
    private final List<Node> roots;
    private static final Logger logger = Logging.getLogger(WorkGraph.class);
    @NotNull
    public static final String METADATA_FILE = "metadata.json";

    public WorkGraph(@NotNull Set<? extends Value<?>> provided, @NotNull Set<WorkDispatcherImpl.Registration> registrations, @Nullable String terminalInputHash, @NotNull Set<? extends Value<?>> requested) {
        Intrinsics.checkNotNullParameter(provided, (String)"provided");
        Intrinsics.checkNotNullParameter(registrations, (String)"registrations");
        Intrinsics.checkNotNullParameter(requested, (String)"requested");
        this.provided = provided;
        this.registrations = registrations;
        this.terminalInputHash = terminalInputHash;
        this.requested = requested;
        this.roots = WorkGraph.buildGraph$default(this, CollectionsKt.toList((Iterable)this.requested), null, 2, null);
        Logger logger = WorkGraph.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        WorkGraph.printGraph$default(this, logger, LogLevel.INFO, this.roots, null, 4, null);
    }

    private final void printGraph(Logger $this$printGraph, LogLevel level, List<Node> nodes, String indent) {
        for (Node node : nodes) {
            logger.log(level, indent + node.getRegistration().getName());
            this.printGraph($this$printGraph, level, node.getDependencies(), indent + "\t");
        }
    }

    static /* synthetic */ void printGraph$default(WorkGraph workGraph, Logger logger, LogLevel logLevel, List list, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        workGraph.printGraph(logger, logLevel, list, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Node> buildGraph(List<? extends Value<?>> requested, Map<WorkDispatcherImpl.Registration, Node> nodeCache) {
        List nodes = new ArrayList();
        for (Value<?> req : requested) {
            void $this$filterTo$iv$iv;
            if (this.provided.contains(req)) continue;
            Iterable $this$filter$iv = this.registrations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WorkDispatcherImpl.Registration it = (WorkDispatcherImpl.Registration)element$iv$iv;
                boolean bl = false;
                if (!it.getOutputs().contains(req)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List producers = (List)destination$iv$iv;
            if (producers.isEmpty()) {
                throw new PaperweightException("No producer or provider for value " + req);
            }
            if (producers.size() > 1) {
                throw new PaperweightException("Multiple producers for value " + req);
            }
            WorkDispatcherImpl.Registration producer = (WorkDispatcherImpl.Registration)CollectionsKt.single((List)producers);
            Node node = nodeCache.get(producer);
            if (node == null) {
                Node node2;
                Node it = node2 = new Node(producer, this.buildGraph(producer.getInputs(), nodeCache), null, 4, null);
                boolean bl = false;
                Iterable $this$forEach$iv = it.getRegistration().getOutputs();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Value output = (Value)element$iv;
                    boolean bl2 = false;
                    if (!(output instanceof FileSystemLocationOutputValue)) continue;
                    ((FileSystemLocationOutputValue)output).setOwner(it.getRegistration().getName());
                }
                node = node2;
            }
            Node node3 = node;
            nodeCache.put(producer, node3);
            ((Collection)nodes).add(node3);
        }
        return nodes;
    }

    static /* synthetic */ List buildGraph$default(WorkGraph workGraph, List list, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = new IdentityHashMap();
        }
        return workGraph.buildGraph(list, map2);
    }

    public final void execute(@NotNull Path work, @NotNull Function1<? super String, Unit> progressEventListener) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter(progressEventListener, (String)"progressEventListener");
        Set visited = new LinkedHashSet();
        Map hashCache = new LinkedHashMap();
        for (Node node : this.roots) {
            WorkGraph.executeNode$default(this, work, node, visited, hashCache, progressEventListener, false, 32, null);
        }
    }

    public static /* synthetic */ void execute$default(WorkGraph workGraph, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = WorkGraph::execute$lambda$3;
        }
        workGraph.execute(path, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void executeNode(Path work, Node node, Set<Node> visited, Map<Value<?>, String> hashCache, Function1<? super String, Unit> progressEventListener, boolean retry2) {
        String string;
        boolean earlyUpToDateCheck;
        boolean root;
        block11: {
            Iterable $this$any$iv = node.getRegistration().getOutputs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Value it = (Value)element$iv;
                    boolean bl2 = false;
                    if (!this.requested.contains(it)) continue;
                    v0 = true;
                    break block11;
                }
                v0 = root = false;
            }
        }
        if (!retry2 && !visited.add(node)) {
            return;
        }
        boolean bl = earlyUpToDateCheck = root && !retry2 && this.terminalInputHash != null;
        if (!earlyUpToDateCheck) {
            for (Node dep : node.getDependencies()) {
                WorkGraph.executeNode$default(this, work, dep, visited, hashCache, progressEventListener, false, 32, null);
            }
        }
        progressEventListener.invoke((Object)node.getRegistration().getName());
        long start = System.nanoTime();
        if (this.terminalInputHash != null && root) {
            string = this.terminalInputHash;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<String> inputHashes = this.hash(node.getRegistration().getInputs(), hashCache);
            Iterable bl2 = inputHashes;
            InputStreamProvider.Companion companion = InputStreamProvider.Companion;
            boolean $i$f$map = false;
            void var16_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(companion.string((String)p0));
            }
            string = UtilsKt.asHexString(UtilsKt.hash$default((List)destination$iv$iv, HashingAlgorithm.SHA256, 0, 2, null));
        }
        String inputHash = string;
        node.setInputHash(inputHash);
        logger.info("Input hash for " + node.getRegistration().getName() + ": " + inputHash);
        this.realizeOutputPaths(node, work, inputHash);
        Path lockFile = work.resolve(node.getRegistration().getName() + "_" + inputHash + "/lock");
        Path metadataFile = work.resolve(node.getRegistration().getName() + "_" + inputHash + "/metadata.json");
        Intrinsics.checkNotNull((Object)lockFile);
        boolean upToDate = (Boolean)File_lockKt.withLock$default(lockFile, 0L, 0L, () -> WorkGraph.executeNode$lambda$8(metadataFile, this, node, hashCache, start, earlyUpToDateCheck, root), 6, null);
        if (upToDate) {
            return;
        }
        if (earlyUpToDateCheck) {
            this.executeNode(work, node, visited, hashCache, progressEventListener, true);
        }
    }

    static /* synthetic */ void executeNode$default(WorkGraph workGraph, Path path, Node node, Set set, Map map2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        workGraph.executeNode(path, node, set, map2, (Function1<? super String, Unit>)function1, bl);
    }

    private final Set<String> collectDependencies(Node node) {
        Set deps = new LinkedHashSet();
        List nodes = new ArrayList();
        nodes.add(node);
        while (!((Collection)nodes).isEmpty()) {
            Node n = (Node)nodes.remove(0);
            for (Node dep : n.getDependencies()) {
                nodes.add(dep);
                if (Intrinsics.areEqual((Object)dep, (Object)node)) continue;
                ((Collection)deps).add(dep.getRegistration().getName() + "_" + dep.getInputHash());
            }
        }
        return deps;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> hash(List<? extends Value<?>> $this$hash, Map<Value<?>, String> cache2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$hash;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value2 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(cache2.computeIfAbsent((Value<?>)it, hash.1.1.INSTANCE));
        }
        return (List)destination$iv$iv;
    }

    private final void realizeOutputPaths(Node node, Path work, String inputHash) {
        for (Value<?> out : node.getRegistration().getOutputs()) {
            if (out instanceof FileSystemLocationOutputValue) {
                ((FileSystemLocationOutputValue)out).setPath(work.resolve(node.getRegistration().getName() + "_" + inputHash + "/" + ((FileSystemLocationOutputValue)out).getName()));
                continue;
            }
            throw new PaperweightException("Unsupported output type " + out.getClass().getName());
        }
    }

    private static final Unit execute$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean executeNode$lambda$8(Path $metadataFile, WorkGraph this$0, Node $node, Map $hashCache, long $start, boolean $earlyUpToDateCheck, boolean $root) {
        Object it;
        Intrinsics.checkNotNull((Object)$metadataFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($metadataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Iterator it2;
            Object object = $metadataFile;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                it2 = (BufferedReader)object;
                boolean bl = false;
                it2 = UtilsKt.getGson().fromJson((Reader)((Object)it2), Metadata.class);
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Iterator metadata = it2;
            if (Intrinsics.areEqual(this$0.hash($node.getRegistration().getOutputs(), $hashCache), ((Metadata)((Object)metadata)).getOutputHashes())) {
                logger.lifecycle("Skipping " + $node.getRegistration().getName() + " (up-to-date)");
                ((Metadata)((Object)metadata)).updateLastUsed().writeTo($metadataFile);
                long took = System.nanoTime() - $start;
                logger.info("Up-to-date check for " + $node.getRegistration().getName() + " took " + io.papermc.paperweight.userdev.internal.util.UtilsKt.formatNs(took) + " (up-to-date)");
                return true;
            }
            Iterable $this$forEach$iv = $node.getRegistration().getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Value)element$iv;
                boolean bl = false;
                $hashCache.remove(it);
            }
            long took = System.nanoTime() - $start;
            logger.info("Up-to-date check for " + $node.getRegistration().getName() + " took " + io.papermc.paperweight.userdev.internal.util.UtilsKt.formatNs(took) + " (out-of-date)");
        }
        if (!$earlyUpToDateCheck) {
            Set<String> set;
            logger.lifecycle("Executing " + $node.getRegistration().getName() + "...");
            long startExec = System.nanoTime();
            try {
                $node.getRegistration().getAction().execute();
            }
            catch (Exception e) {
                throw new PaperweightException("Exception executing " + $node.getRegistration().getName(), e);
            }
            Set<String> deps = $root && this$0.terminalInputHash != null ? this$0.collectDependencies($node) : null;
            List<String> list = this$0.hash($node.getRegistration().getOutputs(), $hashCache);
            Set<String> set2 = deps;
            if (set2 != null) {
                Set<String> element$iv = set2;
                it = element$iv;
                List<String> list2 = list;
                boolean bl = false;
                boolean bl2 = !((Collection)it).isEmpty();
                list = list2;
                set = bl2 ? element$iv : null;
            } else {
                set = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            long l = 0L;
            Set<String> set3 = set;
            List<String> list3 = list;
            Metadata metadata = new Metadata(list3, set3, l, n, defaultConstructorMarker);
            metadata.writeTo($metadataFile);
            long tookExec = System.nanoTime() - startExec;
            logger.lifecycle("Finished " + $node.getRegistration().getName() + " in " + io.papermc.paperweight.userdev.internal.util.UtilsKt.formatNs(tookExec));
        }
        return false;
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkGraph$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "METADATA_FILE", "", "paperweight-userdev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkGraph$Metadata;", "", "outputHashes", "", "", "skippedWhenUpToDate", "", "lastUsed", "", "<init>", "(Ljava/util/List;Ljava/util/Set;J)V", "getOutputHashes", "()Ljava/util/List;", "getSkippedWhenUpToDate", "()Ljava/util/Set;", "getLastUsed", "()J", "updateLastUsed", "writeTo", "", "file", "Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-userdev"})
    @SourceDebugExtension(value={"SMAP\nWorkGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkGraph.kt\nio/papermc/paperweight/userdev/internal/action/WorkGraph$Metadata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
    public static final class Metadata {
        @NotNull
        private final List<String> outputHashes;
        @Nullable
        private final Set<String> skippedWhenUpToDate;
        private final long lastUsed;

        public Metadata(@NotNull List<String> outputHashes, @Nullable Set<String> skippedWhenUpToDate, long lastUsed) {
            Intrinsics.checkNotNullParameter(outputHashes, (String)"outputHashes");
            this.outputHashes = outputHashes;
            this.skippedWhenUpToDate = skippedWhenUpToDate;
            this.lastUsed = lastUsed;
        }

        public /* synthetic */ Metadata(List list, Set set, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = System.currentTimeMillis();
            }
            this(list, set, l);
        }

        @NotNull
        public final List<String> getOutputHashes() {
            return this.outputHashes;
        }

        @Nullable
        public final Set<String> getSkippedWhenUpToDate() {
            return this.skippedWhenUpToDate;
        }

        public final long getLastUsed() {
            return this.lastUsed;
        }

        @NotNull
        public final Metadata updateLastUsed() {
            return Metadata.copy$default(this, null, null, System.currentTimeMillis(), 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object object = PathsKt.createParentDirectories((Path)file2, (FileAttribute[])new FileAttribute[0]);
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl = false;
                UtilsKt.getGson().toJson((Object)this, (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }

        @NotNull
        public final List<String> component1() {
            return this.outputHashes;
        }

        @Nullable
        public final Set<String> component2() {
            return this.skippedWhenUpToDate;
        }

        public final long component3() {
            return this.lastUsed;
        }

        @NotNull
        public final Metadata copy(@NotNull List<String> outputHashes, @Nullable Set<String> skippedWhenUpToDate, long lastUsed) {
            Intrinsics.checkNotNullParameter(outputHashes, (String)"outputHashes");
            return new Metadata(outputHashes, skippedWhenUpToDate, lastUsed);
        }

        public static /* synthetic */ Metadata copy$default(Metadata metadata, List list, Set set, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = metadata.outputHashes;
            }
            if ((n & 2) != 0) {
                set = metadata.skippedWhenUpToDate;
            }
            if ((n & 4) != 0) {
                l = metadata.lastUsed;
            }
            return metadata.copy(list, set, l);
        }

        @NotNull
        public String toString() {
            return "Metadata(outputHashes=" + this.outputHashes + ", skippedWhenUpToDate=" + this.skippedWhenUpToDate + ", lastUsed=" + this.lastUsed + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.outputHashes).hashCode();
            result2 = result2 * 31 + (this.skippedWhenUpToDate == null ? 0 : ((Object)this.skippedWhenUpToDate).hashCode());
            result2 = result2 * 31 + Long.hashCode(this.lastUsed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metadata)) {
                return false;
            }
            Metadata metadata = (Metadata)other;
            if (!Intrinsics.areEqual(this.outputHashes, metadata.outputHashes)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.skippedWhenUpToDate, metadata.skippedWhenUpToDate)) {
                return false;
            }
            return this.lastUsed == metadata.lastUsed;
        }
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkGraph$Node;", "", "registration", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;", "dependencies", "", "inputHash", "", "<init>", "(Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;Ljava/util/List;Ljava/lang/String;)V", "getRegistration", "()Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;", "getDependencies", "()Ljava/util/List;", "getInputHash", "()Ljava/lang/String;", "setInputHash", "(Ljava/lang/String;)V", "paperweight-userdev"})
    public static final class Node {
        @NotNull
        private final WorkDispatcherImpl.Registration registration;
        @NotNull
        private final List<Node> dependencies;
        @Nullable
        private String inputHash;

        public Node(@NotNull WorkDispatcherImpl.Registration registration, @NotNull List<Node> dependencies, @Nullable String inputHash) {
            Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.registration = registration;
            this.dependencies = dependencies;
            this.inputHash = inputHash;
        }

        public /* synthetic */ Node(WorkDispatcherImpl.Registration registration, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(registration, list, string);
        }

        @NotNull
        public final WorkDispatcherImpl.Registration getRegistration() {
            return this.registration;
        }

        @NotNull
        public final List<Node> getDependencies() {
            return this.dependencies;
        }

        @Nullable
        public final String getInputHash() {
            return this.inputHash;
        }

        public final void setInputHash(@Nullable String string) {
            this.inputHash = string;
        }
    }
}

