/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.v5;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.userdev.PaperweightUserExtension;
import io.papermc.paperweight.userdev.internal.action.FileCollectionValue;
import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.StringValue;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.ValuesKt;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.userdev.internal.action.ZippedFileValue;
import io.papermc.paperweight.userdev.internal.setup.BundleInfo;
import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetup;
import io.papermc.paperweight.userdev.internal.setup.action.AccessTransformMinecraftAction;
import io.papermc.paperweight.userdev.internal.setup.action.ApplyDevBundlePatchesAction;
import io.papermc.paperweight.userdev.internal.setup.action.DecompileMinecraftAction;
import io.papermc.paperweight.userdev.internal.setup.action.ExtractFromBundlerAction;
import io.papermc.paperweight.userdev.internal.setup.action.FilterVanillaJarAction;
import io.papermc.paperweight.userdev.internal.setup.action.FixMinecraftJarAction;
import io.papermc.paperweight.userdev.internal.setup.action.GenerateMappingsAction;
import io.papermc.paperweight.userdev.internal.setup.action.RemapMinecraftAction;
import io.papermc.paperweight.userdev.internal.setup.action.RunPaperclipAction;
import io.papermc.paperweight.userdev.internal.setup.action.VanillaServerDownloads;
import io.papermc.paperweight.userdev.internal.setup.v5.DevBundleV5;
import io.papermc.paperweight.userdev.internal.setup.v5.SetupHandlerImplV5;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.MavenDep;
import io.papermc.paperweight.util.NioKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.jvm.toolchain.JavaLauncher;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\u0016\u0010-\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010(R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010$\u00a8\u00061"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/v5/SetupHandlerImplV5;", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler;", "parameters", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;", "bundle", "Lio/papermc/paperweight/userdev/internal/setup/BundleInfo;", "Lio/papermc/paperweight/userdev/internal/setup/v5/DevBundleV5$Config;", "<init>", "(Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;Lio/papermc/paperweight/userdev/internal/setup/BundleInfo;)V", "createDispatcher", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher;", "context", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ExecutionContext;", "populateCompileConfiguration", "", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ConfigurationContext;", "dependencySet", "Lorg/gradle/api/artifacts/DependencySet;", "populateRuntimeConfiguration", "completedOutput", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$ArtifactsResult;", "generateArtifacts", "extractReobfMappings", "output", "Ljava/nio/file/Path;", "afterEvaluate", "legacyDefaultJavaLauncher", "minecraftVersion", "", "getMinecraftVersion", "()Ljava/lang/String;", "deobfNamespace", "getDeobfNamespace", "pluginRemapArgs", "", "getPluginRemapArgs", "()Ljava/util/List;", "paramMappings", "Lio/papermc/paperweight/util/MavenDep;", "getParamMappings", "()Lio/papermc/paperweight/util/MavenDep;", "decompiler", "getDecompiler", "remapper", "getRemapper", "mache", "getMache", "libraryRepositories", "getLibraryRepositories", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nSetupHandlerImplV5.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupHandlerImplV5.kt\nio/papermc/paperweight/userdev/internal/setup/v5/SetupHandlerImplV5\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 5 TypeOfExtensions.kt\norg/gradle/kotlin/dsl/TypeOfExtensionsKt\n*L\n1#1,296:1\n1869#2,2:297\n1869#2,2:299\n1617#2,9:302\n1869#2:311\n1870#2:313\n1626#2:314\n1#3:301\n1#3:312\n136#4:315\n137#4:317\n28#5:316\n*S KotlinDebug\n*F\n+ 1 SetupHandlerImplV5.kt\nio/papermc/paperweight/userdev/internal/setup/v5/SetupHandlerImplV5\n*L\n192#1:297,2\n205#1:299,2\n256#1:302,9\n256#1:311\n256#1:313\n256#1:314\n256#1:312\n263#1:315\n263#1:317\n263#1:316\n*E\n"})
public final class SetupHandlerImplV5
implements SetupHandler {
    @NotNull
    private final UserdevSetup.Parameters parameters;
    @NotNull
    private final BundleInfo<DevBundleV5.Config> bundle;
    @Nullable
    private volatile SetupHandler.ArtifactsResult completedOutput;

    public SetupHandlerImplV5(@NotNull UserdevSetup.Parameters parameters, @NotNull BundleInfo<DevBundleV5.Config> bundle) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(bundle, (String)"bundle");
        this.parameters = parameters;
        this.bundle = bundle;
    }

    private final WorkDispatcher createDispatcher(SetupHandler.ExecutionContext context) {
        WorkDispatcher dispatcher = WorkDispatcher.Companion.create(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.parameters.getCache())));
        Object object = this.parameters.getBundleZipHash().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        dispatcher.overrideTerminalInputHash((String)object);
        Value<JavaLauncher> javaLauncher = ValuesKt.javaLauncherValue(context.getJavaLauncher());
        StringValue mcVer = new StringValue(this.bundle.getConfig().getMinecraftVersion());
        FileValue bundleZip = ValuesKt.fileValue(this.bundle.getZip());
        Value[] valueArray = new Value[]{javaLauncher, mcVer, bundleZip};
        dispatcher.provided(valueArray);
        FileValue fileValue = dispatcher.outputFile("vanillaServer.jar");
        FileValue fileValue2 = dispatcher.outputFile("mojangServerMappings.txt");
        Object object2 = this.parameters.getDownloadService().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        VanillaServerDownloads vanillaDownloads = (VanillaServerDownloads)dispatcher.register("vanillaServerDownloads", (WorkDispatcher.Action)new VanillaServerDownloads(mcVer, fileValue, fileValue2, (DownloadService)object2));
        RunPaperclipAction applyPaperclip = (RunPaperclipAction)dispatcher.register("applyPaperclipPatch", (WorkDispatcher.Action)new RunPaperclipAction(javaLauncher, bundleZip, new StringValue(this.bundle.getConfig().getBuildData().getMojangMappedPaperclipFile()), dispatcher.outputFile("output.jar"), vanillaDownloads.getServerJar(), mcVer, false, 64, null));
        dispatcher.provided((Value<?>)applyPaperclip.getPaperclipPath());
        ExtractFromBundlerAction extract = (ExtractFromBundlerAction)dispatcher.register("extractFromBundler", (WorkDispatcher.Action)new ExtractFromBundlerAction(vanillaDownloads.getServerJar(), dispatcher.outputFile("vanillaServer.jar"), dispatcher.outputDir("minecraftLibraries")));
        FilterVanillaJarAction filterVanillaJar = (FilterVanillaJarAction)dispatcher.register("filterVanillaJar", (WorkDispatcher.Action)new FilterVanillaJarAction(extract.getVanillaServerJar(), ValuesKt.stringListValue(this.bundle.getConfig().getBuildData().getVanillaJarIncludes()), dispatcher.outputFile("output.jar")));
        dispatcher.provided((Value<?>)filterVanillaJar.getIncludes());
        GenerateMappingsAction generateMappings2 = (GenerateMappingsAction)dispatcher.register("generateMappings", (WorkDispatcher.Action)new GenerateMappingsAction(javaLauncher, context.getWorkerExecutor(), vanillaDownloads.getServerMappings(), filterVanillaJar.getOutputJar(), new FileCollectionValue(context.getParamMappingsConfig()), extract.getMinecraftLibraryJars(), dispatcher.outputFile("output.tiny")));
        dispatcher.provided((Value<?>)generateMappings2.getParamMappings());
        RemapMinecraftAction remap = (RemapMinecraftAction)dispatcher.register("remapMinecraft", (WorkDispatcher.Action)new RemapMinecraftAction(javaLauncher, ValuesKt.stringListValue(this.bundle.getConfig().getBuildData().getMinecraftRemapArgs()), filterVanillaJar.getOutputJar(), extract.getMinecraftLibraryJars(), generateMappings2.getOutputMappings(), new FileCollectionValue(context.getRemapperConfig()), dispatcher.outputFile("output.jar")));
        dispatcher.provided((Value<?>)remap.getMinecraftRemapArgs());
        dispatcher.provided((Value<?>)remap.getRemapper());
        FixMinecraftJarAction fix = (FixMinecraftJarAction)dispatcher.register("fixMinecraftJar", (WorkDispatcher.Action)new FixMinecraftJarAction(javaLauncher, context.getWorkerExecutor(), remap.getOutputJar(), dispatcher.outputFile("output.jar"), extract.getVanillaServerJar(), false, 32, null));
        AccessTransformMinecraftAction at = (AccessTransformMinecraftAction)dispatcher.register("accessTransformMinecraft", (WorkDispatcher.Action)new AccessTransformMinecraftAction(javaLauncher, context.getWorkerExecutor(), new ZippedFileValue(this.bundle.getZip(), this.bundle.getConfig().getBuildData().getAccessTransformFile()), fix.getOutputJar(), dispatcher.outputFile("output.jar")));
        dispatcher.provided((Value<?>)at.getAt());
        DecompileMinecraftAction decompile = (DecompileMinecraftAction)dispatcher.register("decompileMinecraftServer", (WorkDispatcher.Action)new DecompileMinecraftAction(javaLauncher, at.getOutputJar(), dispatcher.outputFile("output.jar"), extract.getMinecraftLibraryJars(), ValuesKt.stringListValue(this.bundle.getConfig().getDecompile().getArgs()), new FileCollectionValue(context.getDecompilerConfig())));
        Value[] valueArray2 = new Value[]{decompile.getDecompileArgs(), decompile.getDecompiler()};
        dispatcher.provided(valueArray2);
        ApplyDevBundlePatchesAction applyPatches = (ApplyDevBundlePatchesAction)dispatcher.register("applyDevBundlePatches", (WorkDispatcher.Action)new ApplyDevBundlePatchesAction(decompile.getOutputJar(), bundleZip, new StringValue(this.bundle.getConfig().getPatchDir()), dispatcher.outputFile("output.jar"), applyPaperclip.getOutputJar()));
        dispatcher.provided((Value<?>)applyPatches.getPatchesPath());
        return dispatcher;
    }

    @Override
    public void populateCompileConfiguration(@NotNull SetupHandler.ConfigurationContext context, @NotNull DependencySet dependencySet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dependencySet, (String)"dependencySet");
        Object object = new Object[]{context.getSetupTask().flatMap((Transformer)populateCompileConfiguration.1.INSTANCE)};
        dependencySet.add((Object)context.getDependencyFactory().create(context.getLayout().files((Object[])object)));
        object = new String[]{this.bundle.getConfig().getApiCoordinates(), this.bundle.getConfig().getMojangApiCoordinates()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String coordinate = (String)element$iv;
            boolean bl = false;
            dependencySet.add((Object)context.getDependencyFactory().create((CharSequence)coordinate));
        }
        for (String coordinates : this.bundle.getConfig().getBuildData().getCompileDependencies()) {
            dependencySet.add((Object)context.getDependencyFactory().create((CharSequence)coordinates));
        }
    }

    @Override
    public void populateRuntimeConfiguration(@NotNull SetupHandler.ConfigurationContext context, @NotNull DependencySet dependencySet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dependencySet, (String)"dependencySet");
        Object object = new Object[]{context.getSetupTask().flatMap((Transformer)populateRuntimeConfiguration.1.INSTANCE)};
        dependencySet.add((Object)context.getDependencyFactory().create(context.getLayout().files((Object[])object)));
        object = new String[]{this.bundle.getConfig().getApiCoordinates(), this.bundle.getConfig().getMojangApiCoordinates()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalModuleDependency dep;
            ExternalModuleDependency externalModuleDependency;
            String coordinate = (String)element$iv;
            boolean bl = false;
            ExternalModuleDependency it = externalModuleDependency = context.getDependencyFactory().create((CharSequence)coordinate);
            boolean bl2 = false;
            it.setTransitive(false);
            Intrinsics.checkNotNullExpressionValue((Object)externalModuleDependency, (String)"also(...)");
            dependencySet.add((Object)dep);
        }
        for (String coordinates : this.bundle.getConfig().getBuildData().getRuntimeDependencies()) {
            ExternalModuleDependency dep;
            ExternalModuleDependency externalModuleDependency;
            ExternalModuleDependency it = externalModuleDependency = context.getDependencyFactory().create((CharSequence)coordinates);
            boolean bl = false;
            it.setTransitive(false);
            Intrinsics.checkNotNullExpressionValue((Object)externalModuleDependency, (String)"also(...)");
            dependencySet.add((Object)dep);
        }
    }

    @Override
    @NotNull
    public synchronized SetupHandler.ArtifactsResult generateArtifacts(@NotNull SetupHandler.ExecutionContext context) {
        SetupHandler.ArtifactsResult artifactsResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.completedOutput != null) {
            SetupHandler.ArtifactsResult artifactsResult2 = this.completedOutput;
            if (artifactsResult2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return artifactsResult2;
        }
        WorkDispatcher dispatcher = this.createDispatcher(context);
        FileValue request = (Boolean)this.parameters.getGenSources().get() != false ? ((ApplyDevBundlePatchesAction)dispatcher.registered("applyDevBundlePatches")).getOutputJar() : ((RunPaperclipAction)dispatcher.registered("applyPaperclipPatch")).getOutputJar();
        SetupHandler.ExecutionContext.withProgressLogger$default(context, null, null, arg_0 -> SetupHandlerImplV5.generateArtifacts$lambda$5(dispatcher, request, arg_0), 3, null);
        SetupHandler.ArtifactsResult it = artifactsResult = new SetupHandler.ArtifactsResult((Path)request.get(), null);
        boolean bl = false;
        this.completedOutput = it;
        return artifactsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractReobfMappings(@NotNull Path output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        AutoCloseable autoCloseable = NioKt.openZipSafe(this.bundle.getZip());
        Throwable throwable = null;
        try {
            FileSystemReference fs = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Path path = fs.getPath(this.bundle.getConfig().getBuildData().getReobfMappingsFile());
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Path path2 = Files.copy(path, output, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"copy(...)");
            Path path3 = path2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void afterEvaluate(@NotNull SetupHandler.ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SetupHandler.super.afterEvaluate(context);
        this.legacyDefaultJavaLauncher(context);
    }

    /*
     * WARNING - void declaration
     */
    private final void legacyDefaultJavaLauncher(SetupHandler.ConfigurationContext context) {
        void $this$configure$iv;
        void $this$mapNotNullTo$iv$iv;
        char[] cArray = new char[]{'.', '-'};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)this.bundle.getConfig().getMinecraftVersion(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toIntOrNull((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List versionParts = (List)destination$iv$iv;
        if (((Number)versionParts.get(1)).intValue() > 19) {
            return;
        }
        if (versionParts.size() >= 3 && ((Number)versionParts.get(1)).intValue() == 19 && ((Number)versionParts.get(2)).intValue() >= 3) {
            return;
        }
        ExtensionContainer extensionContainer = context.getProject().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        $this$mapNotNull$iv = extensionContainer;
        Function1 action$iv = arg_0 -> SetupHandlerImplV5.legacyDefaultJavaLauncher$lambda$9(context, arg_0);
        boolean $i$f$configure = false;
        boolean $i$f$typeOf = false;
        $this$configure$iv.configure((TypeOf)new TypeOf<PaperweightUserExtension>(){}, new Action(action$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object t) {
                this.function.invoke(t);
            }
        });
    }

    @Override
    @NotNull
    public String getMinecraftVersion() {
        return this.bundle.getConfig().getMinecraftVersion();
    }

    @Override
    @NotNull
    public String getDeobfNamespace() {
        return "mojang+yarn";
    }

    @Override
    @NotNull
    public List<String> getPluginRemapArgs() {
        return this.bundle.getConfig().getBuildData().getPluginRemapArgs();
    }

    @Override
    @NotNull
    public MavenDep getParamMappings() {
        return this.bundle.getConfig().getBuildData().getParamMappings();
    }

    @Override
    @NotNull
    public MavenDep getDecompiler() {
        return this.bundle.getConfig().getDecompile().getDep();
    }

    @Override
    @NotNull
    public MavenDep getRemapper() {
        return this.bundle.getConfig().getRemapper();
    }

    @Override
    @Nullable
    public MavenDep getMache() {
        return null;
    }

    @Override
    @NotNull
    public List<String> getLibraryRepositories() {
        return this.bundle.getConfig().getBuildData().getLibraryRepositories();
    }

    private static final Unit generateArtifacts$lambda$5$lambda$4(ProgressLogger $progressLogger, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $progressLogger.progress(it);
        return Unit.INSTANCE;
    }

    private static final Unit generateArtifacts$lambda$5(WorkDispatcher $dispatcher, FileValue $request, ProgressLogger progressLogger) {
        Intrinsics.checkNotNullParameter((Object)progressLogger, (String)"progressLogger");
        Value[] valueArray = new Value[]{$request};
        $dispatcher.dispatch(valueArray, (Function1<? super String, Unit>)((Function1)arg_0 -> SetupHandlerImplV5.generateArtifacts$lambda$5$lambda$4(progressLogger, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit legacyDefaultJavaLauncher$lambda$9(SetupHandler.ConfigurationContext $context, PaperweightUserExtension $this$configure) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
        $this$configure.getJavaLauncher().convention($context.getJavaToolchainService().launcherFor((Action)legacyDefaultJavaLauncher.1.1.INSTANCE));
        return Unit.INSTANCE;
    }
}

