/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import java.security.MessageDigest;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R2\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/util/HashingAlgorithm;", "", "algorithmName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getAlgorithmName", "()Ljava/lang/String;", "SHA256", "SHA1", "threadLocalMessageDigest", "Ljava/lang/ThreadLocal;", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "createDigest", "threadLocalDigest", "getThreadLocalDigest", "()Ljava/security/MessageDigest;", "paperweight-lib"})
public final class HashingAlgorithm
extends Enum<HashingAlgorithm> {
    @NotNull
    private final String algorithmName;
    private final ThreadLocal<MessageDigest> threadLocalMessageDigest;
    public static final /* enum */ HashingAlgorithm SHA256 = new HashingAlgorithm("SHA-256");
    public static final /* enum */ HashingAlgorithm SHA1 = new HashingAlgorithm("SHA-1");
    private static final /* synthetic */ HashingAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private HashingAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
        this.threadLocalMessageDigest = ThreadLocal.withInitial(new Supplier(this){
            final /* synthetic */ HashingAlgorithm this$0;
            {
                this.this$0 = $receiver;
            }

            public final MessageDigest get() {
                return this.this$0.createDigest();
            }
        });
    }

    @NotNull
    public final String getAlgorithmName() {
        return this.algorithmName;
    }

    @NotNull
    public final MessageDigest createDigest() {
        MessageDigest messageDigest = MessageDigest.getInstance(this.algorithmName);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return messageDigest;
    }

    @NotNull
    public final MessageDigest getThreadLocalDigest() {
        MessageDigest messageDigest = this.threadLocalMessageDigest.get();
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"get(...)");
        return messageDigest;
    }

    public static HashingAlgorithm[] values() {
        return (HashingAlgorithm[])$VALUES.clone();
    }

    public static HashingAlgorithm valueOf(String value2) {
        return Enum.valueOf(HashingAlgorithm.class, value2);
    }

    @NotNull
    public static EnumEntries<HashingAlgorithm> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = hashingAlgorithmArray = new HashingAlgorithm[]{HashingAlgorithm.SHA256, HashingAlgorithm.SHA1};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

