/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ'\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00030\u0005H&\u00a2\u0006\u0002\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/util/InputStreamProvider;", "", "use", "T", "op", "Lkotlin/Function1;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "paperweight-lib"})
public interface InputStreamProvider {
    @NotNull
    public static final Companion Companion = io.papermc.paperweight.util.InputStreamProvider$Companion.$$INSTANCE;

    public <T> T use(@NotNull Function1<? super InputStream, ? extends T> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/util/InputStreamProvider$Companion;", "", "<init>", "()V", "file", "Lio/papermc/paperweight/util/InputStreamProvider;", "path", "Ljava/nio/file/Path;", "dir", "", "wrap", "input", "Ljava/io/InputStream;", "string", "value", "", "paperweight-lib"})
    @SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\nio/papermc/paperweight/util/InputStreamProvider$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,503:1\n608#2:504\n*S KotlinDebug\n*F\n+ 1 utils.kt\nio/papermc/paperweight/util/InputStreamProvider$Companion\n*L\n338#1:504\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final InputStreamProvider file(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new InputStreamProvider(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <T> T use(Function1<? super InputStream, ? extends T> op2) {
                    Object object;
                    Intrinsics.checkNotNullParameter(op2, (String)"op");
                    Object object2 = this.$path;
                    Object object3 = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream((Path)object2, Arrays.copyOf(object3, ((OpenOption[])object3).length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    object2 = inputStream;
                    object3 = null;
                    try {
                        object = op2.invoke(object2);
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                    }
                    return (T)object;
                }
            };
        }

        @NotNull
        public final List<InputStreamProvider> dir(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Sequence $this$sortedBy$iv = PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]);
            boolean $i$f$sortedBy = false;
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Path it = (Path)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((Object)it.toAbsolutePath()).toString());
                    it = (Path)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Object)it.toAbsolutePath()).toString())));
                }
            }), Companion::dir$lambda$1));
        }

        @NotNull
        public final InputStreamProvider wrap(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new InputStreamProvider(input){
                final /* synthetic */ InputStream $input;
                {
                    this.$input = $input;
                }

                public <T> T use(Function1<? super InputStream, ? extends T> op2) {
                    Intrinsics.checkNotNullParameter(op2, (String)"op");
                    return (T)op2.invoke((Object)this.$input);
                }
            };
        }

        @NotNull
        public final InputStreamProvider string(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = value2;
            Charset charset = Charsets.UTF_8;
            byte[] byArray2 = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            return this.wrap(new ByteArrayInputStream(byArray2));
        }

        private static final InputStreamProvider dir$lambda$1(Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return $$INSTANCE.file(file2);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

