/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001aB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0004H\u0016J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/util/data/FileEntry;", "T", "", "hash", "", "id", "path", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getId", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPath", "toString", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Lio/papermc/paperweight/util/data/FileEntry;", "equals", "", "other", "hashCode", "", "Companion", "paperweight-lib"})
public final class FileEntry<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hash;
    private final T id;
    @NotNull
    private final String path;
    @NotNull
    public static final String VERSION_JSON = "version.json";
    @NotNull
    public static final String VERSIONS_DIR = "META-INF/versions";
    @NotNull
    public static final String LIBRARIES_DIR = "META-INF/libraries";
    @NotNull
    public static final String VERSIONS_LIST = "META-INF/versions.list";
    @NotNull
    public static final String LIBRARIES_LIST = "META-INF/libraries.list";

    public FileEntry(@NotNull String hash2, T id, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.hash = hash2;
        this.id = id;
        this.path = path;
    }

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    public final T getId() {
        return this.id;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public String toString() {
        return this.hash + "\t" + this.id + "\t" + this.path;
    }

    @NotNull
    public final String component1() {
        return this.hash;
    }

    public final T component2() {
        return this.id;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    @NotNull
    public final FileEntry<T> copy(@NotNull String hash2, T id, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new FileEntry<T>(hash2, id, path);
    }

    public static /* synthetic */ FileEntry copy$default(FileEntry fileEntry, String string, Object object, String string2, int n, Object object2) {
        if ((n & 1) != 0) {
            string = fileEntry.hash;
        }
        if ((n & 2) != 0) {
            object = fileEntry.id;
        }
        if ((n & 4) != 0) {
            string2 = fileEntry.path;
        }
        return fileEntry.copy(string, object, string2);
    }

    public int hashCode() {
        int result2 = this.hash.hashCode();
        result2 = result2 * 31 + (this.id == null ? 0 : this.id.hashCode());
        result2 = result2 * 31 + this.path.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileEntry)) {
            return false;
        }
        FileEntry fileEntry = (FileEntry)other;
        if (!Intrinsics.areEqual((Object)this.hash, (Object)fileEntry.hash)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.id, fileEntry.id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)fileEntry.path);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ4\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\f0\u000b\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/util/data/FileEntry$Companion;", "", "<init>", "()V", "VERSION_JSON", "", "VERSIONS_DIR", "LIBRARIES_DIR", "VERSIONS_LIST", "LIBRARIES_LIST", "parse", "", "Lio/papermc/paperweight/util/data/FileEntry;", "file", "Ljava/nio/file/Path;", "T", "transform", "Lkotlin/Function1;", "paperweight-lib"})
    @SourceDebugExtension(value={"SMAP\nFileEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileEntry.kt\nio/papermc/paperweight/util/data/FileEntry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1617#2,9:61\n1869#2:70\n1870#2:72\n1626#2:73\n1#3:71\n*S KotlinDebug\n*F\n+ 1 FileEntry.kt\nio/papermc/paperweight/util/data/FileEntry$Companion\n*L\n49#1:61,9\n49#1:70\n49#1:72\n49#1:73\n49#1:71\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FileEntry<String>> parse(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.parse(file2, Companion::parse$lambda$0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T> List<FileEntry<T>> parse(@NotNull Path file2, @NotNull Function1<? super String, ? extends T> transform2) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            Path path = file2;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                FileEntry<Object> fileEntry;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) {
                    fileEntry = null;
                } else {
                    String[] stringArray = new String[]{"\t"};
                    List list2 = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String hash2 = (String)list2.get(0);
                    String id = (String)list2.get(1);
                    String path2 = (String)list2.get(2);
                    fileEntry = new FileEntry<Object>(hash2, transform2.invoke((Object)id), path2);
                }
                if (fileEntry == null) continue;
                FileEntry<Object> it$iv$iv = fileEntry;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final String parse$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

