/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ$\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\b\u0010!\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\t\u0010$\u001a\u00020\u0003H\u00c2\u0003J\t\u0010%\u001a\u00020\u0003H\u00c2\u0003J\t\u0010&\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J?\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000b\u00a8\u00060"}, d2={"Lio/papermc/paperweight/util/data/MavenArtifact;", "", "group", "", "artifact", "version", "classifier", "extension", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassifier", "()Ljava/lang/String;", "getExtension", "classifierText", "getClassifierText", "ext", "getExt", "path", "getPath", "file", "getFile", "gav", "getGav", "downloadToFile", "", "downloadService", "Lio/papermc/paperweight/DownloadService;", "targetFile", "Ljava/nio/file/Path;", "repos", "", "downloadToDir", "targetDir", "toString", "addSlash", "url", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "Companion", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nMavenArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenArtifact.kt\nio/papermc/paperweight/util/data/MavenArtifact\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class MavenArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String group;
    @NotNull
    private final String artifact;
    @NotNull
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String extension;

    public MavenArtifact(@NotNull String group, @NotNull String artifact, @NotNull String version, @Nullable String classifier, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
    }

    public /* synthetic */ MavenArtifact(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    @Nullable
    public final String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public final String getExtension() {
        return this.extension;
    }

    private final String getClassifierText() {
        return this.classifier != null ? "-" + this.classifier : "";
    }

    private final String getExt() {
        String string = this.extension;
        if (string == null) {
            string = "jar";
        }
        return string;
    }

    private final String getPath() {
        return StringsKt.replace$default((String)this.group, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + this.artifact + "/" + this.version + "/" + this.getFile();
    }

    @NotNull
    public final String getFile() {
        return this.artifact + "-" + this.version + this.getClassifierText() + "." + this.getExt();
    }

    @NotNull
    public final String getGav() {
        return this.group + ":" + this.artifact + ":" + this.version;
    }

    public final void downloadToFile(@NotNull DownloadService downloadService, @NotNull Path targetFile, @NotNull List<String> repos) {
        Intrinsics.checkNotNullParameter((Object)downloadService, (String)"downloadService");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        Path path = targetFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        Exception thrown = null;
        for (String repo : repos) {
            try {
                DownloadService.download$default(downloadService, this.addSlash(repo) + this.getPath(), targetFile, null, 4, null);
                return;
            }
            catch (Exception e) {
                if (thrown != null) {
                    ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)e);
                    continue;
                }
                thrown = e;
            }
        }
        object = thrown;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            throw new PaperweightException("Failed to download artifact: " + this + ". Checked repos: " + repos, (Throwable)it);
        }
    }

    @NotNull
    public final Path downloadToDir(@NotNull DownloadService downloadService, @NotNull Path targetDir, @NotNull List<String> repos) {
        Intrinsics.checkNotNullParameter((Object)downloadService, (String)"downloadService");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        Path out = targetDir.resolve(this.getFile());
        Intrinsics.checkNotNull((Object)out);
        this.downloadToFile(downloadService, out, repos);
        return out;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        int n = 50;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toString_u24lambda_u241.append(this.group).append(':').append(this.artifact).append(':').append(this.version);
        if (this.classifier != null) {
            $this$toString_u24lambda_u241.append(':').append(this.classifier);
        }
        if (this.extension != null) {
            $this$toString_u24lambda_u241.append('@').append(this.extension);
        }
        return stringBuilder.toString();
    }

    private final String addSlash(String url) {
        return StringsKt.endsWith$default((CharSequence)url, (char)'/', (boolean)false, (int)2, null) ? url : url + "/";
    }

    private final String component1() {
        return this.group;
    }

    private final String component2() {
        return this.artifact;
    }

    private final String component3() {
        return this.version;
    }

    @Nullable
    public final String component4() {
        return this.classifier;
    }

    @Nullable
    public final String component5() {
        return this.extension;
    }

    @NotNull
    public final MavenArtifact copy(@NotNull String group, @NotNull String artifact, @NotNull String version, @Nullable String classifier, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new MavenArtifact(group, artifact, version, classifier, extension);
    }

    public static /* synthetic */ MavenArtifact copy$default(MavenArtifact mavenArtifact, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = mavenArtifact.group;
        }
        if ((n & 2) != 0) {
            string2 = mavenArtifact.artifact;
        }
        if ((n & 4) != 0) {
            string3 = mavenArtifact.version;
        }
        if ((n & 8) != 0) {
            string4 = mavenArtifact.classifier;
        }
        if ((n & 0x10) != 0) {
            string5 = mavenArtifact.extension;
        }
        return mavenArtifact.copy(string, string2, string3, string4, string5);
    }

    public int hashCode() {
        int result2 = this.group.hashCode();
        result2 = result2 * 31 + this.artifact.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + (this.classifier == null ? 0 : this.classifier.hashCode());
        result2 = result2 * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MavenArtifact)) {
            return false;
        }
        MavenArtifact mavenArtifact = (MavenArtifact)other;
        if (!Intrinsics.areEqual((Object)this.group, (Object)mavenArtifact.group)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifact, (Object)mavenArtifact.artifact)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)mavenArtifact.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classifier, (Object)mavenArtifact.classifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.extension, (Object)mavenArtifact.extension);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J4\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\n0\t*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/util/data/MavenArtifact$Companion;", "", "<init>", "()V", "parse", "Lio/papermc/paperweight/util/data/MavenArtifact;", "text", "", "nextSubstring", "Lkotlin/Pair;", "", "startIndex", "stops", "", "goToEnd", "", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MavenArtifact parse(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            char[] cArray = new char[]{':'};
            Pair pair = io.papermc.paperweight.util.data.MavenArtifact$Companion.nextSubstring$default(this, text, 0, cArray, false, 4, null);
            String group = (String)pair.component1();
            int groupIndex = ((Number)pair.component2()).intValue();
            char[] cArray2 = new char[]{':'};
            Pair pair2 = io.papermc.paperweight.util.data.MavenArtifact$Companion.nextSubstring$default(this, text, groupIndex, cArray2, false, 4, null);
            String artifact = (String)pair2.component1();
            int artifactIndex = ((Number)pair2.component2()).intValue();
            char[] cArray3 = new char[]{':', '@'};
            Pair<String, Integer> pair3 = this.nextSubstring(text, artifactIndex, cArray3, true);
            String version = (String)pair3.component1();
            int versionIndex = ((Number)pair3.component2()).intValue();
            char[] cArray4 = new char[]{':', '@'};
            Pair<String, Integer> pair4 = this.nextSubstring(text, versionIndex, cArray4, true);
            String classifier = (String)pair4.component1();
            int classifierIndex = ((Number)pair4.component2()).intValue();
            String extension = (String)this.nextSubstring(text, classifierIndex, new char[0], true).component1();
            if (group == null) {
                throw new PaperweightException("Invalid Maven artifact descriptor (no groupId found): " + text);
            }
            if (artifact == null) {
                throw new PaperweightException("Invalid Maven artifact descriptor (no artifactId found): " + text);
            }
            if (version == null) {
                throw new PaperweightException("Invalid Maven artifact descriptor (no version found): " + text);
            }
            return new MavenArtifact(group, artifact, version, classifier, extension);
        }

        private final Pair<String, Integer> nextSubstring(String $this$nextSubstring, int startIndex, char[] stops, boolean goToEnd) {
            Pair pair;
            if (startIndex == $this$nextSubstring.length()) {
                return TuplesKt.to(null, (Object)startIndex);
            }
            int endIndex = StringsKt.indexOfAny$default((CharSequence)$this$nextSubstring, (char[])stops, (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex != -1) {
                String string = $this$nextSubstring.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pair = TuplesKt.to((Object)string, (Object)(endIndex + 1));
            } else if (goToEnd) {
                String string = $this$nextSubstring.substring(startIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pair = TuplesKt.to((Object)string, (Object)$this$nextSubstring.length());
            } else {
                pair = TuplesKt.to(null, (Object)startIndex);
            }
            return pair;
        }

        static /* synthetic */ Pair nextSubstring$default(Companion companion, String string, int n, char[] cArray, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion.nextSubstring(string, n, cArray, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

