/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.Int2IntMap;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntArrayList;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntList;
import paper.libs.codechicken.repack.it.unimi.dsi.fastutil.ints.IntListIterator;

public class PatienceMatch {
    private String chars1;
    private String chars2;
    private int[] unique1;
    private int[] unique2;
    private int[] matches;
    private final IntList subChars = new IntArrayList();

    private void match(int start1, int end1, int start2, int end2) {
        while (start1 < end1 && start2 < end2 && this.chars1.charAt(start1) == this.chars2.charAt(start2)) {
            this.matches[start1++] = start2++;
        }
        while (start1 < end1 && start2 < end2 && this.chars1.charAt(end1 - 1) == this.chars2.charAt(end2 - 1)) {
            this.matches[--end1] = --end2;
        }
        if (start1 == end1 || start2 == end2 || end1 - start1 + end2 - start2 <= 3) {
            return;
        }
        boolean any2 = false;
        for (Int2IntMap.Entry entry : this.lcsUnique(start1, end1, start2, end2)) {
            int m2;
            int m1 = entry.getIntKey();
            this.matches[m1] = m2 = entry.getIntValue();
            any2 = true;
            this.match(start1, m1, start2, m2);
            start1 = m1 + 1;
            start2 = m2 + 1;
        }
        if (any2) {
            this.match(start1, end1, start2, end2);
        }
    }

    private int[] match() {
        this.matches = new int[this.chars1.length()];
        for (int i2 = 0; i2 < this.chars1.length(); ++i2) {
            this.matches[i2] = -1;
        }
        this.match(0, this.chars1.length(), 0, this.chars2.length());
        return this.matches;
    }

    public int[] match(String chars1, String chars2, int maxChar) {
        if (this.unique1 == null || this.unique1.length < maxChar) {
            this.unique1 = new int[maxChar];
            this.unique2 = new int[maxChar];
            for (int i2 = 0; i2 < maxChar; ++i2) {
                this.unique2[i2] = -1;
                this.unique1[i2] = -1;
            }
        }
        this.chars1 = chars1;
        this.chars2 = chars2;
        return this.match();
    }

    private List<Int2IntMap.Entry> lcsUnique(int start1, int end1, int start2, int end2) {
        char c;
        int i2;
        for (i2 = start1; i2 < end1; ++i2) {
            c = this.chars1.charAt(i2);
            if (this.unique1[c] == -1) {
                this.unique1[c] = i2;
                this.subChars.add(c);
                continue;
            }
            this.unique1[c] = -2;
        }
        for (i2 = start2; i2 < end2; ++i2) {
            c = this.chars2.charAt(i2);
            if (this.unique1[c] < 0) continue;
            this.unique2[c] = this.unique2[c] == -1 ? i2 : -2;
        }
        IntArrayList common1 = new IntArrayList();
        IntArrayList common2 = new IntArrayList();
        IntListIterator intListIterator = this.subChars.iterator();
        while (intListIterator.hasNext()) {
            int i3 = (Integer)intListIterator.next();
            if (this.unique1[i3] >= 0 && this.unique2[i3] >= 0) {
                common1.add(this.unique1[i3]);
                common2.add(this.unique2[i3]);
            }
            this.unique2[i3] = -1;
            this.unique1[i3] = -1;
        }
        this.subChars.clear();
        if (common2.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Int2IntMap.Entry> ret2 = new ArrayList<Int2IntMap.Entry>();
        for (int i4 : PatienceMatch.lasIndices(common2)) {
            ret2.add(new AbstractInt2IntMap.BasicEntry(common1.getInt(i4), common2.getInt(i4)));
        }
        return ret2;
    }

    public static int[] lasIndices(IntList sequence) {
        if (sequence.size() == 0) {
            return new int[0];
        }
        ArrayList<LCANode> pileTops = new ArrayList<LCANode>();
        pileTops.add(new LCANode(0, null));
        for (int i2 = 1; i2 < sequence.size(); ++i2) {
            int v = sequence.getInt(i2);
            int a = 0;
            int b = pileTops.size();
            while (a != b) {
                int c = (a + b) / 2;
                if (sequence.getInt(((LCANode)pileTops.get((int)c)).value) > v) {
                    b = c;
                    continue;
                }
                a = c + 1;
            }
            if (a < pileTops.size()) {
                pileTops.set(a, new LCANode(i2, a > 0 ? (LCANode)pileTops.get(a - 1) : null));
                continue;
            }
            pileTops.add(new LCANode(i2, (LCANode)pileTops.get(a - 1)));
        }
        int[] las = new int[pileTops.size()];
        int j = pileTops.size() - 1;
        LCANode node = (LCANode)pileTops.get(j);
        while (node != null) {
            las[j--] = node.value;
            node = node.prev;
        }
        return las;
    }

    private static class LCANode {
        public final int value;
        public final LCANode prev;

        public LCANode(int value2, LCANode prev) {
            this.value = value2;
            this.prev = prev;
        }
    }
}

