/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import paper.libs.codechicken.repack.net.covers1624.quack.collection.ColUtils;
import paper.libs.org.jetbrains.annotations.Nullable;

public class FileCollector {
    private final Map<String, CollectedEntry> files = new LinkedHashMap<String, CollectedEntry>();

    public boolean consume(String name2, List<String> lines) {
        if (this.files.containsKey(name2)) {
            return false;
        }
        this.files.put(name2, new LinesCollectedEntry(lines));
        return true;
    }

    public boolean consume(String name2, byte[] bytes2) {
        if (this.files.containsKey(name2)) {
            return false;
        }
        this.files.put(name2, new BinaryCollectedEntry(bytes2));
        return true;
    }

    public Map<String, CollectedEntry> get() {
        return Collections.unmodifiableMap(this.files);
    }

    public Set<String> keySet() {
        return this.get().keySet();
    }

    public Collection<CollectedEntry> values() {
        return this.get().values();
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    public CollectedEntry getSingleFile() {
        if (this.files.isEmpty()) {
            return null;
        }
        if (this.files.size() != 1) {
            throw new IllegalStateException("Expected 1 file in FileCollector, got: " + this.files.size());
        }
        return ColUtils.only(this.files.values());
    }

    public static class BinaryCollectedEntry
    extends CollectedEntry {
        public final byte[] bytes;

        public BinaryCollectedEntry(byte[] bytes2) {
            this.bytes = bytes2;
        }

        @Override
        public byte[] toBytes(String lineEnding, boolean emptyNewline) throws IOException {
            return this.bytes;
        }
    }

    public static class LinesCollectedEntry
    extends CollectedEntry {
        public final List<String> lines;

        public LinesCollectedEntry(List<String> lines) {
            this.lines = Collections.unmodifiableList(new ArrayList<String>(lines));
        }

        @Override
        public byte[] toBytes(String lineEnding, boolean emptyNewline) throws IOException {
            String file2 = String.join((CharSequence)lineEnding, this.lines);
            if (emptyNewline) {
                file2 = file2 + lineEnding;
            }
            return file2.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static abstract class CollectedEntry {
        public abstract byte[] toBytes(String var1, boolean var2) throws IOException;
    }
}

