/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.diffpatch.util;

import groovy.lang.Closure;
import java.io.File;
import java.util.Locale;
import java.util.function.Supplier;
import org.gradle.api.Project;
import paper.libs.codechicken.diffpatch.util.PatchMode;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveFormat;

public class GradleUtil {
    public static File resolveFile(Project project, Object obj) {
        if (obj instanceof Closure) {
            return GradleUtil.resolveFile(project, ((Closure)obj).call());
        }
        if (obj instanceof Supplier) {
            return GradleUtil.resolveFile(project, ((Supplier)obj).get());
        }
        return project.file(obj);
    }

    public static PatchMode resolvePatchMode(Object value2) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        if (value2 instanceof PatchMode) {
            return (PatchMode)((Object)value2);
        }
        if (value2 instanceof CharSequence) {
            String upper = value2.toString().toUpperCase(Locale.ROOT);
            try {
                return PatchMode.valueOf(upper);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown PatchMode String value: " + value2.toString());
            }
        }
        throw new IllegalArgumentException("Unable to parse PatchMode, Unknown value: " + value2.toString());
    }

    public static ArchiveFormat resolveArchiveFormat(Object value2) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        if (value2 instanceof ArchiveFormat) {
            return (ArchiveFormat)((Object)value2);
        }
        if (value2 instanceof CharSequence) {
            String upper = value2.toString().toUpperCase(Locale.ROOT);
            try {
                return ArchiveFormat.valueOf(upper);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown ArchiveFormat String value: " + value2.toString());
            }
        }
        throw new IllegalArgumentException("Unable to parse ArchiveFormat, Unknown value: " + value2.toString());
    }
}

