/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.joptsimple.util;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import paper.libs.codechicken.repack.joptsimple.ValueConversionException;
import paper.libs.codechicken.repack.joptsimple.ValueConverter;

public abstract class EnumConverter<E extends Enum<E>>
implements ValueConverter<E> {
    private final Class<E> clazz;
    private String delimiters = "[,]";

    protected EnumConverter(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E convert(String value2) {
        for (Enum each : (Enum[])this.valueType().getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(value2)) continue;
            return (E)each;
        }
        throw new ValueConversionException(this.message(value2));
    }

    @Override
    public Class<E> valueType() {
        return this.clazz;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    @Override
    public String valuePattern() {
        EnumSet<E> values2 = EnumSet.allOf(this.valueType());
        StringBuilder builder = new StringBuilder();
        builder.append(this.delimiters.charAt(0));
        Iterator i2 = values2.iterator();
        while (i2.hasNext()) {
            builder.append(((Enum)i2.next()).toString());
            if (!i2.hasNext()) continue;
            builder.append(this.delimiters.charAt(1));
        }
        builder.append(this.delimiters.charAt(2));
        return builder.toString();
    }

    private String message(String value2) {
        ResourceBundle bundle = ResourceBundle.getBundle("paper.libs.codechicken.repack.joptsimple.ExceptionMessages");
        Object[] arguments = new Object[]{value2, this.valuePattern()};
        String template = bundle.getString(EnumConverter.class.getName() + ".message");
        return new MessageFormat(template).format(arguments);
    }
}

