/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.net.covers1624.quack.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import paper.libs.codechicken.repack.net.covers1624.quack.annotation.ReplaceWith;
import paper.libs.codechicken.repack.net.covers1624.quack.annotation.ReplaceWithExpr;
import paper.libs.codechicken.repack.net.covers1624.quack.collection.ForEachAbort;
import paper.libs.codechicken.repack.net.covers1624.quack.util.Copyable;
import paper.libs.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import paper.libs.org.jetbrains.annotations.ApiStatus;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.Nullable;

public class ColUtils {
    public static <T> T[] slice(T[] arr, int from, int until) {
        int low = Math.max(from, 0);
        int high = Math.min(Math.max(until, 0), arr.length);
        int size = Math.max(high - low, 0);
        Object[] result2 = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        if (size > 0) {
            System.arraycopy(arr, low, result2, 0, size);
        }
        return result2;
    }

    @Nullable
    public static <T> T maxBy(T[] col, ToIntFunction<T> func) {
        return ColUtils.maxBy(Arrays.asList(col), func);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWithExpr(value="maxByOrDefault(col, () -> ..., null)")
    public static <T> T maxBy(Iterable<T> col, ToIntFunction<T> func) {
        return ColUtils.maxByOrDefault(col, func, null);
    }

    public static <T> T requireMaxBy(Iterable<T> col, ToIntFunction<T> func) {
        T ret2 = ColUtils.maxByOrDefault(col, func, null);
        if (ret2 == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return ret2;
    }

    @Nullable
    @Contract(value="_,_,!null -> !null")
    public static <T> T maxByOrDefault(Iterable<T> col, ToIntFunction<T> func, @Nullable T default_) {
        int max = Integer.MIN_VALUE;
        Object maxT = null;
        for (T t : col) {
            int x = func.applyAsInt(t);
            if (x <= max) continue;
            maxT = t;
            max = x;
        }
        return (T)(maxT == null ? default_ : maxT);
    }

    public static <T> boolean allMatch(T[] col, Predicate<T> func) {
        return ColUtils.allMatch(Arrays.asList(col), func);
    }

    public static <T> boolean allMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (func.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> findFirst(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> headOption(Iterable<T> col) {
        return Optional.ofNullable(ColUtils.headOrDefault(col));
    }

    public static <T> T head(Iterable<T> col) {
        T head = ColUtils.headOrDefault(col);
        if (head == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return head;
    }

    @Nullable
    public static <T> T headOrDefault(Iterable<T> col) {
        return ColUtils.headOrDefault(col, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T headOrDefault(Iterable<T> col, @Nullable T _default) {
        class Cons
        implements Consumer<T> {
            @Nullable
            T t;
            final /* synthetic */ Object val$_default;

            Cons(Object object) {
                this.val$_default = object;
                this.t = this.val$_default;
            }

            @Override
            public void accept(T t) {
                if (this.t != null) {
                    throw new ForEachAbort();
                }
                this.t = t;
            }
        }
        Cons cons = new Cons(_default);
        try {
            col.forEach(cons);
        }
        catch (ForEachAbort forEachAbort) {
            // empty catch block
        }
        return cons.t;
    }

    public static <T> Optional<T> tailOption(Iterable<T> col) {
        return Optional.ofNullable(ColUtils.tailOrDefault(col));
    }

    public static <T> T tail(Iterable<T> col) {
        T tail = ColUtils.tailOrDefault(col);
        if (tail == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return tail;
    }

    @Nullable
    public static <T> T tailOrDefault(Iterable<T> col) {
        return ColUtils.tailOrDefault(col, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T tailOrDefault(Iterable<T> col, @Nullable T _default) {
        class Cons
        implements Consumer<T> {
            @Nullable
            T t;
            final /* synthetic */ Object val$_default;

            Cons(Object object) {
                this.val$_default = object;
                this.t = this.val$_default;
            }

            @Override
            public void accept(T t) {
                this.t = t;
            }
        }
        Cons cons = new Cons(_default);
        col.forEach(cons);
        return cons.t;
    }

    @SafeVarargs
    public static <T> boolean containsKeys(Map<T, ?> map2, T ... keys) {
        for (T object : keys) {
            if (map2.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] addToArrayFirstNull(T[] array, T value2) {
        int nullIndex = -1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            T v = array[i2];
            if (v != null) continue;
            nullIndex = i2;
            break;
        }
        if (nullIndex == -1) {
            T[] copy = ColUtils.createNewArray(array, array.length + 1);
            System.arraycopy(array, 0, copy, 0, array.length);
            nullIndex = array.length;
            array = copy;
        }
        array[nullIndex] = value2;
        return array;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value2 : array) {
            if (value2 == null) continue;
            list.add(value2);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value2 : array) {
            if (value2 == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int countNonNull(T[] array) {
        return ColUtils.count(array, Objects::nonNull);
    }

    public static <T> int count(T[] array, Function<T, Boolean> check) {
        int counter = 0;
        for (T value2 : array) {
            if (!check.apply(value2).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> T[] fill(T[] array, T value2) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            T newValue = value2;
            if (value2 instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value2);
                newValue = copyable.copy();
            }
            array[i2] = newValue;
        }
        return array;
    }

    public static <T> void fillArray(T[] array, T value2, Function<T, Boolean> check) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!check.apply(array[i2]).booleanValue()) continue;
            T newValue = value2;
            if (value2 instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value2);
                newValue = copyable.copy();
            }
            array[i2] = newValue;
        }
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])SneakyUtils.unsafeCast(dst);
            for (int i2 = destPos; i2 < destPos + length; ++i2) {
                if (c[i2] == null) continue;
                oa[i2] = c[i2].copy();
            }
        }
    }

    public static <T> int indexOf(T[] array, T object) {
        if (object == null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (array[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < array.length; ++i3) {
                if (!object.equals(array[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static <T> int indexOfRef(T[] array, T object) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != object) continue;
            return i2;
        }
        return -1;
    }

    public static <T> T[] createNewArray(T[] array) {
        return ColUtils.createNewArray(array, array.length);
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        Class newType = (Class)SneakyUtils.unsafeCast(array.getClass());
        Object[] copy = newType.equals(Object[].class) ? (Object[])SneakyUtils.unsafeCast(new Object[length]) : (Object[])SneakyUtils.unsafeCast(ColUtils.newArray(newType.getComponentType(), length));
        return copy;
    }

    public static <T> T[] newArray(Class<T> arrayClass, int length) {
        return (Object[])SneakyUtils.unsafeCast(Array.newInstance(arrayClass, length));
    }

    public static <T> T[] rollArray(T[] input, int shift) {
        T[] newArray = ColUtils.createNewArray(input);
        for (int i2 = 0; i2 < input.length; ++i2) {
            int newPos = (i2 + shift) % input.length;
            if (newPos < 0) {
                newPos += input.length;
            }
            newArray[newPos] = input[i2];
        }
        return newArray;
    }

    public static <T> boolean contains(T[] input, T element) {
        for (T test : input) {
            if (!Objects.equals(test, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] inverse(T[] input, T[] allElements) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : allElements) {
            if (ColUtils.contains(input, e)) continue;
            list.add(e);
        }
        return list.toArray(ColUtils.createNewArray(input, list.size()));
    }

    public static <T> boolean isNullOrContainsNull(T @Nullable [] input) {
        if (input == null) {
            return true;
        }
        for (T t : input) {
            if (t != null) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> toList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : arr) {
            list.add(i2);
        }
        return list;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWith(value="Use FastStream in the first place. This has terrible performance.")
    public static <E> Iterable<E> iterable(Stream<E> stream) {
        return stream::iterator;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWithExpr(value="StreamSupport.stream(iter.spliterator(), false)")
    public static <E> Stream<E> stream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWithExpr(value="StreamSupport.stream(iter.spliterator(), true)")
    public static <E> Stream<E> parallelStream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWith(value="Use FastStream in the first place.")
    @Nullable
    public static <T> T onlyOrDefault(Stream<T> stream) {
        return ColUtils.onlyOrDefault(stream, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWith(value="Use FastStream in the first place.")
    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T onlyOrDefault(Stream<T> stream, @Nullable T _default) {
        return ColUtils.onlyOrDefault(ColUtils.iterable(stream), _default);
    }

    @Nullable
    public static <T> T onlyOrDefault(Iterable<T> iterable) {
        return ColUtils.onlyOrDefault(iterable, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T onlyOrDefault(Iterable<T> iterable, @Nullable T _default) {
        final class Cons
        implements Consumer<T> {
            @Nullable
            T thing;
            boolean found;
            final /* synthetic */ Object val$_default;

            Cons(Object object) {
                this.val$_default = object;
                this.thing = this.val$_default;
                this.found = false;
            }

            @Override
            public void accept(T t) {
                if (this.found) {
                    this.thing = this.val$_default;
                    throw new ForEachAbort();
                }
                this.found = true;
                this.thing = t;
            }
        }
        Cons cons = new Cons(_default);
        try {
            iterable.forEach(cons);
        }
        catch (ForEachAbort forEachAbort) {
            // empty catch block
        }
        return cons.thing;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    @ReplaceWith(value="Use FastStream in the first place.")
    public static <T> T only(Stream<T> stream) {
        return ColUtils.only(ColUtils.iterable(stream));
    }

    public static <T> T only(Iterable<T> col) {
        final class Cons
        implements Consumer<T> {
            @Nullable
            T thing = null;
            boolean found = false;

            Cons() {
            }

            @Override
            public void accept(T t) {
                if (this.found) {
                    throw new IllegalArgumentException("More than one element.");
                }
                this.found = true;
                this.thing = t;
            }
        }
        Cons cons = new Cons();
        col.forEach(cons);
        if (!cons.found) {
            throw new IllegalArgumentException("Not found.");
        }
        return cons.thing;
    }

    public static <T> Iterator<T> iterator(T[] arr) {
        return ColUtils.iterator(arr, 0, arr.length);
    }

    public static <T> Iterator<T> iterator(final T[] arr, final int from, final int until) {
        if (until > arr.length) {
            throw new IndexOutOfBoundsException();
        }
        return new Iterator<T>(){
            int i;
            {
                this.i = from;
            }

            @Override
            public boolean hasNext() {
                return this.i < until;
            }

            @Override
            public T next() {
                return arr[this.i++];
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (this.i < until) {
                    action.accept(arr[this.i]);
                    ++this.i;
                }
            }
        };
    }

    public static <T> void reverse(T[] array) {
        int i2 = 0;
        for (int j = array.length - 1; i2 < j; ++i2, --j) {
            T temp = array[i2];
            array[i2] = array[j];
            array[j] = temp;
        }
    }
}

