/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.codechicken.repack.org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.InputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.MemoryLimitException;
import paper.libs.codechicken.repack.org.apache.commons.compress.compressors.CompressorInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.utils.CountingInputStream;
import paper.libs.codechicken.repack.org.apache.commons.compress.utils.IOUtils;
import paper.libs.codechicken.repack.org.apache.commons.compress.utils.InputStreamStatistics;
import paper.libs.codechicken.repack.org.tukaani.xz.SingleXZInputStream;
import paper.libs.codechicken.repack.org.tukaani.xz.XZ;
import paper.libs.codechicken.repack.org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public static boolean matches(byte[] signature, int length) {
        if (length < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (signature[i2] == XZ.HEADER_MAGIC[i2]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated) throws IOException {
        this(inputStream, decompressConcatenated, -1);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated, int memoryLimitInKb) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = decompressConcatenated ? new XZInputStream((InputStream)this.countingStream, memoryLimitInKb) : new SingleXZInputStream((InputStream)this.countingStream, memoryLimitInKb);
    }

    @Override
    public int read() throws IOException {
        try {
            int ret2 = this.in.read();
            this.count(ret2 == -1 ? -1 : 1);
            return ret2;
        }
        catch (paper.libs.codechicken.repack.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        try {
            int ret2 = this.in.read(buf, off, len);
            this.count(ret2);
            return ret2;
        }
        catch (paper.libs.codechicken.repack.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return IOUtils.skip(this.in, n);
        }
        catch (paper.libs.codechicken.repack.org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

