/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import java.util.Objects;
import paper.libs.com.google.errorprone.annotations.Immutable;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Immutable
public final class MemberReference {
    @NotNull
    private final String className;
    @NotNull
    private final String memberName;
    @Nullable
    private final String memberDesc;

    public MemberReference(@NotNull String className, @NotNull String memberName, @Nullable String memberDesc) {
        this.className = className;
        this.memberName = memberName;
        this.memberDesc = memberDesc;
    }

    @NotNull
    public static MemberReference of(@NotNull MethodData method) {
        return new MemberReference(method.parentClass().name(), method.name(), method.descriptorText());
    }

    @NotNull
    public static MemberReference of(@NotNull FieldData field) {
        return new MemberReference(field.parentClass().name(), field.name(), field.fieldType().asInternalName());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MemberReference of(@NotNull MethodMapping mapping) {
        return new MemberReference(((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), mapping.getObfuscatedDescriptor());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MemberReference of(@NotNull FieldMapping mapping) {
        FieldType type = LorenzUtil.getType(mapping);
        return new MemberReference(((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), type == null ? null : type.toString());
    }

    @NotNull
    public String className() {
        return this.className;
    }

    @NotNull
    public String name() {
        return this.memberName;
    }

    @Nullable
    public String desc() {
        return this.memberDesc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberReference that = (MemberReference)o;
        return this.className.equals(that.className) && this.memberName.equals(that.memberName) && Objects.equals(this.memberDesc, that.memberDesc);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.memberName, this.memberDesc);
    }

    public String toString() {
        if (this.memberDesc != null) {
            return this.className + "#" + this.memberName + " " + this.memberDesc;
        }
        return this.className + "#" + this.memberName;
    }
}

