/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.net.fabricmc.mapping.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import paper.libs.net.fabricmc.mapping.tree.ClassDef;
import paper.libs.net.fabricmc.mapping.tree.FieldDef;
import paper.libs.net.fabricmc.mapping.tree.MethodDef;
import paper.libs.net.fabricmc.mapping.tree.TinyTree;
import paper.libs.net.fabricmc.mapping.util.EntryTriple;
import paper.libs.org.objectweb.asm.commons.Remapper;

public final class AsmRemapperFactory {
    private final Map<String, SoftReference<SimpleRemapper>> remapperCache = new HashMap<String, SoftReference<SimpleRemapper>>();
    private final TinyTree mapping;

    public AsmRemapperFactory(TinyTree mapping) {
        this.mapping = mapping;
    }

    public Remapper getRemapper(String from, String to) {
        SimpleRemapper ret2;
        String key = from + ":" + to;
        SoftReference<SimpleRemapper> remapperRef = this.remapperCache.get(key);
        if (remapperRef != null && (ret2 = remapperRef.get()) != null) {
            return ret2;
        }
        SimpleRemapper remapper = new SimpleRemapper(this.mapping.getClasses(), from, to);
        this.remapperCache.put(key, new SoftReference<SimpleRemapper>(remapper));
        return remapper;
    }

    private static final class SimpleRemapper
    extends Remapper {
        private final Map<String, String> classNames = new HashMap<String, String>();
        private final Map<EntryTriple, String> fieldNames = new HashMap<EntryTriple, String>();
        private final Map<EntryTriple, String> methodNames = new HashMap<EntryTriple, String>();

        SimpleRemapper(Collection<ClassDef> classes, String from, String to) {
            for (ClassDef clz : classes) {
                String className = clz.getName(from);
                this.classNames.put(className, clz.getName(to));
                for (FieldDef field : clz.getFields()) {
                    this.fieldNames.put(new EntryTriple(className, field.getName(from), field.getDescriptor(from)), field.getName(to));
                }
                for (MethodDef method : clz.getMethods()) {
                    this.methodNames.put(new EntryTriple(className, method.getName(from), method.getDescriptor(from)), method.getName(to));
                }
            }
        }

        @Override
        public String map(String typeName) {
            return this.classNames.getOrDefault(typeName, typeName);
        }

        @Override
        public String mapFieldName(String owner, String name2, String descriptor) {
            return this.fieldNames.getOrDefault(new EntryTriple(owner, name2, descriptor), name2);
        }

        @Override
        public String mapMethodName(String owner, String name2, String descriptor) {
            return this.methodNames.getOrDefault(new EntryTriple(owner, name2, descriptor), name2);
        }
    }
}

