/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.protocol;

import java.io.IOException;
import paper.libs.org.apache.http.HttpException;
import paper.libs.org.apache.http.HttpRequest;
import paper.libs.org.apache.http.HttpRequestInterceptor;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.protocol.HttpContext;
import paper.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

