/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.MappingSetModelFactory;
import paper.libs.org.cadixdev.lorenz.impl.MappingSetModelFactoryImpl;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;
import paper.libs.org.cadixdev.lorenz.model.jar.CascadingFieldTypeProvider;

public class MappingSetImpl
implements MappingSet {
    private final Map<String, TopLevelClassMapping> topLevelClasses = new ConcurrentHashMap<String, TopLevelClassMapping>();
    private final MappingSetModelFactory modelFactory;
    private CascadingFieldTypeProvider fieldTypeProvider = new CascadingFieldTypeProvider();

    public MappingSetImpl() {
        this(new MappingSetModelFactoryImpl());
    }

    public MappingSetImpl(MappingSetModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    public MappingSetModelFactory getModelFactory() {
        return this.modelFactory;
    }

    @Override
    public Collection<TopLevelClassMapping> getTopLevelClassMappings() {
        return Collections.unmodifiableCollection(this.topLevelClasses.values());
    }

    @Override
    public TopLevelClassMapping createTopLevelClassMapping(String obfuscatedName, String deobfuscatedName) {
        return this.topLevelClasses.compute(obfuscatedName.replace('.', '/'), (name2, existingMapping) -> {
            if (existingMapping != null) {
                return (TopLevelClassMapping)existingMapping.setDeobfuscatedName(deobfuscatedName);
            }
            return this.getModelFactory().createTopLevelClassMapping(this, (String)name2, deobfuscatedName);
        });
    }

    @Override
    public Optional<TopLevelClassMapping> getTopLevelClassMapping(String obfuscatedName) {
        return Optional.ofNullable(this.topLevelClasses.get(obfuscatedName.replace('.', '/')));
    }

    @Override
    public boolean hasTopLevelClassMapping(String obfuscatedName) {
        return this.topLevelClasses.containsKey(obfuscatedName.replace('.', '/'));
    }

    @Override
    public CascadingFieldTypeProvider getFieldTypeProvider() {
        return this.fieldTypeProvider;
    }
}

