/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.matching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.alg.interfaces.MatchingAlgorithm;

public class KuhnMunkresMinimalWeightBipartitePerfectMatching<V, E>
implements MatchingAlgorithm<V, E> {
    private final Graph<V, E> graph;
    private Set<? extends V> partition1;
    private Set<? extends V> partition2;

    public KuhnMunkresMinimalWeightBipartitePerfectMatching(Graph<V, E> graph, Set<? extends V> partition1, Set<? extends V> partition2) {
        if (graph == null) {
            throw new IllegalArgumentException("Input graph cannot be null");
        }
        this.graph = graph;
        if (partition1 == null) {
            throw new IllegalArgumentException("Partition 1 cannot be null");
        }
        this.partition1 = partition1;
        if (partition2 == null) {
            throw new IllegalArgumentException("Partition 2 cannot be null");
        }
        this.partition2 = partition2;
    }

    @Override
    public MatchingAlgorithm.Matching<V, E> getMatching() {
        if (this.partition1.size() != this.partition2.size()) {
            throw new IllegalArgumentException("Graph supplied isn't complete bipartite with equally sized partitions!");
        }
        if (!GraphTests.isBipartitePartition(this.graph, this.partition1, this.partition2)) {
            throw new IllegalArgumentException("Invalid bipartite partition provided");
        }
        int partition = this.partition1.size();
        int edges = this.graph.edgeSet().size();
        if (edges != partition * partition) {
            throw new IllegalArgumentException("Graph supplied isn't complete bipartite with equally sized partitions!");
        }
        if (!GraphTests.isSimple(this.graph)) {
            throw new IllegalArgumentException("Only simple graphs supported");
        }
        ArrayList<V> firstPartition = new ArrayList<V>(this.partition1);
        ArrayList<V> secondPartition = new ArrayList<V>(this.partition2);
        int[] matching = this.graph.vertexSet().isEmpty() ? new int[]{} : new KuhnMunkresMatrixImplementation<V, E>(this.graph, firstPartition, secondPartition).buildMatching();
        HashSet<E> edgeSet = new HashSet<E>();
        double weight = 0.0;
        for (int i2 = 0; i2 < matching.length; ++i2) {
            E e = this.graph.getEdge(firstPartition.get(i2), secondPartition.get(matching[i2]));
            weight += this.graph.getEdgeWeight(e);
            edgeSet.add(e);
        }
        return new MatchingAlgorithm.MatchingImpl<V, E>(this.graph, edgeSet, weight);
    }

    static class KuhnMunkresMatrixImplementation<V, E> {
        private double[][] costMatrix;
        private double[][] excessMatrix;
        boolean[] rowsCovered;
        boolean[] columnsCovered;
        private int[] columnMatched;
        private int[] rowMatched;

        public KuhnMunkresMatrixImplementation(Graph<V, E> G, List<? extends V> S, List<? extends V> T) {
            int partition = S.size();
            this.costMatrix = new double[partition][];
            for (int i2 = 0; i2 < S.size(); ++i2) {
                V source = S.get(i2);
                this.costMatrix[i2] = new double[partition];
                for (int j = 0; j < T.size(); ++j) {
                    V target = T.get(j);
                    if (source.equals(target)) continue;
                    this.costMatrix[i2][j] = G.getEdgeWeight(G.getEdge(source, target));
                }
            }
        }

        protected int[] buildMatching() {
            int height = this.costMatrix.length;
            int width = this.costMatrix[0].length;
            this.excessMatrix = this.makeExcessMatrix();
            this.rowsCovered = new boolean[height];
            this.columnsCovered = new boolean[width];
            this.columnMatched = new int[height];
            this.rowMatched = new int[width];
            Arrays.fill(this.columnMatched, -1);
            Arrays.fill(this.rowMatched, -1);
            while (this.buildMaximalMatching() < width) {
                this.buildVertexCoverage();
                this.extendEqualityGraph();
            }
            return Arrays.copyOf(this.columnMatched, height);
        }

        double[][] makeExcessMatrix() {
            int i2;
            double[][] excessMatrix = new double[this.costMatrix.length][];
            for (i2 = 0; i2 < excessMatrix.length; ++i2) {
                excessMatrix[i2] = Arrays.copyOf(this.costMatrix[i2], this.costMatrix[i2].length);
            }
            for (i2 = 0; i2 < excessMatrix.length; ++i2) {
                int j;
                double cheapestTaskCost = Double.MAX_VALUE;
                for (j = 0; j < excessMatrix[i2].length; ++j) {
                    if (!(cheapestTaskCost > excessMatrix[i2][j])) continue;
                    cheapestTaskCost = excessMatrix[i2][j];
                }
                j = 0;
                while (j < excessMatrix[i2].length) {
                    double[] dArray = excessMatrix[i2];
                    int n = j++;
                    dArray[n] = dArray[n] - cheapestTaskCost;
                }
            }
            for (int j = 0; j < excessMatrix[0].length; ++j) {
                int i3;
                double cheapestWorkerCost = Double.MAX_VALUE;
                for (i3 = 0; i3 < excessMatrix.length; ++i3) {
                    if (!(cheapestWorkerCost > excessMatrix[i3][j])) continue;
                    cheapestWorkerCost = excessMatrix[i3][j];
                }
                for (i3 = 0; i3 < excessMatrix.length; ++i3) {
                    double[] dArray = excessMatrix[i3];
                    int n = j;
                    dArray[n] = dArray[n] - cheapestWorkerCost;
                }
            }
            return excessMatrix;
        }

        int buildMaximalMatching() {
            int matchingSizeLowerBound = 0;
            for (int i2 = 0; i2 < this.columnMatched.length; ++i2) {
                if (this.columnMatched[i2] == -1) continue;
                ++matchingSizeLowerBound;
            }
            block1: for (int j = 0; j < this.excessMatrix[0].length; ++j) {
                if (this.rowMatched[j] != -1) continue;
                for (int i3 = 0; i3 < this.excessMatrix.length; ++i3) {
                    if (this.excessMatrix[i3][j] != 0.0 || this.columnMatched[i3] != -1) continue;
                    ++matchingSizeLowerBound;
                    this.columnMatched[i3] = j;
                    this.rowMatched[j] = i3;
                    continue block1;
                }
            }
            if (matchingSizeLowerBound == this.excessMatrix[0].length) {
                return matchingSizeLowerBound;
            }
            boolean[] rowsVisited = new boolean[this.excessMatrix.length];
            boolean[] colsVisited = new boolean[this.excessMatrix[0].length];
            int matchingSize = 0;
            boolean extending = true;
            while (extending && matchingSize < this.excessMatrix.length) {
                int j;
                Arrays.fill(rowsVisited, false);
                Arrays.fill(colsVisited, false);
                extending = false;
                for (j = 0; j < this.excessMatrix.length; ++j) {
                    if (this.rowMatched[j] != -1 || colsVisited[j]) continue;
                    extending |= new MatchExtender(rowsVisited, colsVisited).extend(j);
                }
                matchingSize = 0;
                for (j = 0; j < this.rowMatched.length; ++j) {
                    if (this.rowMatched[j] == -1) continue;
                    ++matchingSize;
                }
            }
            return matchingSize;
        }

        void buildVertexCoverage() {
            int i2;
            int j;
            Arrays.fill(this.columnsCovered, false);
            Arrays.fill(this.rowsCovered, false);
            boolean[] invertible = new boolean[this.rowsCovered.length];
            block0: for (int i3 = 0; i3 < this.excessMatrix.length; ++i3) {
                if (this.columnMatched[i3] != -1) {
                    invertible[i3] = true;
                    continue;
                }
                for (j = 0; j < this.excessMatrix[i3].length; ++j) {
                    if (Double.compare(this.excessMatrix[i3][j], 0.0) != 0) continue;
                    invertible[i3] = true;
                    this.rowsCovered[i3] = true;
                    continue block0;
                }
            }
            boolean cont = true;
            while (cont) {
                for (i2 = 0; i2 < this.excessMatrix.length; ++i2) {
                    if (!this.rowsCovered[i2]) continue;
                    for (int j2 = 0; j2 < this.excessMatrix[i2].length; ++j2) {
                        if (Double.compare(this.excessMatrix[i2][j2], 0.0) != 0 || this.columnsCovered[j2]) continue;
                        this.columnsCovered[j2] = true;
                    }
                }
                cont = false;
                for (j = 0; j < this.columnsCovered.length; ++j) {
                    if (!this.columnsCovered[j] || this.rowMatched[j] == -1 || this.rowsCovered[this.rowMatched[j]]) continue;
                    cont = true;
                    this.rowsCovered[this.rowMatched[j]] = true;
                }
            }
            for (i2 = 0; i2 < this.rowsCovered.length; ++i2) {
                if (!invertible[i2]) continue;
                int n = i2;
                this.rowsCovered[n] = this.rowsCovered[n] ^ true;
            }
            assert (KuhnMunkresMatrixImplementation.uncovered(this.excessMatrix, this.rowsCovered, this.columnsCovered) == 0);
            assert (KuhnMunkresMatrixImplementation.minimal(this.rowMatched, this.rowsCovered, this.columnsCovered));
        }

        void extendEqualityGraph() {
            int j;
            int i2;
            double minExcess = Double.MAX_VALUE;
            for (i2 = 0; i2 < this.excessMatrix.length; ++i2) {
                if (this.rowsCovered[i2]) continue;
                for (j = 0; j < this.excessMatrix[i2].length; ++j) {
                    if (this.columnsCovered[j] || !(minExcess > this.excessMatrix[i2][j])) continue;
                    minExcess = this.excessMatrix[i2][j];
                }
            }
            for (i2 = 0; i2 < this.excessMatrix.length; ++i2) {
                if (!this.rowsCovered[i2]) continue;
                j = 0;
                while (j < this.excessMatrix[i2].length) {
                    double[] dArray = this.excessMatrix[i2];
                    int n = j++;
                    dArray[n] = dArray[n] + minExcess;
                }
            }
            for (int j2 = 0; j2 < this.excessMatrix[0].length; ++j2) {
                if (this.columnsCovered[j2]) continue;
                for (int i3 = 0; i3 < this.excessMatrix.length; ++i3) {
                    double[] dArray = this.excessMatrix[i3];
                    int n = j2;
                    dArray[n] = dArray[n] - minExcess;
                }
            }
        }

        private static boolean minimal(int[] match, boolean[] rowsCovered, boolean[] colsCovered) {
            int matched = 0;
            for (int i2 = 0; i2 < match.length; ++i2) {
                if (match[i2] == -1) continue;
                ++matched;
            }
            int covered = 0;
            for (int i3 = 0; i3 < rowsCovered.length; ++i3) {
                if (rowsCovered[i3]) {
                    ++covered;
                }
                if (!colsCovered[i3]) continue;
                ++covered;
            }
            return matched == covered;
        }

        private static int uncovered(double[][] excessMatrix, boolean[] rowsCovered, boolean[] colsCovered) {
            int uncoveredZero = 0;
            for (int i2 = 0; i2 < excessMatrix.length; ++i2) {
                if (rowsCovered[i2]) continue;
                for (int j = 0; j < excessMatrix[i2].length; ++j) {
                    if (colsCovered[j] || Double.compare(excessMatrix[i2][j], 0.0) != 0) continue;
                    ++uncoveredZero;
                }
            }
            return uncoveredZero;
        }

        protected class MatchExtender {
            private final boolean[] rowsVisited;
            private final boolean[] colsVisited;

            private MatchExtender(boolean[] rowsVisited, boolean[] colsVisited) {
                this.rowsVisited = rowsVisited;
                this.colsVisited = colsVisited;
            }

            public boolean extend(int initialCol) {
                return this.extendMatchingEL(initialCol);
            }

            private boolean extendMatchingOL(int pathTailRow, int pathTailCol) {
                if (KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow] == -1) {
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).columnMatched[pathTailRow] = pathTailCol;
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).rowMatched[pathTailCol] = pathTailRow;
                    return true;
                }
                this.rowsVisited[pathTailRow] = true;
                if (this.colsVisited[KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow]]) {
                    return false;
                }
                boolean extending = this.extendMatchingEL(KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow]);
                if (extending) {
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).columnMatched[pathTailRow] = pathTailCol;
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).rowMatched[pathTailCol] = pathTailRow;
                }
                return extending;
            }

            private boolean extendMatchingEL(int pathTailCol) {
                this.colsVisited[pathTailCol] = true;
                for (int i2 = 0; i2 < KuhnMunkresMatrixImplementation.this.excessMatrix.length; ++i2) {
                    boolean extending;
                    if (KuhnMunkresMatrixImplementation.this.excessMatrix[i2][pathTailCol] != 0.0 || this.rowsVisited[i2] || !(extending = this.extendMatchingOL(i2, pathTailCol))) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

