/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.tukaani.xz;

import java.io.IOException;
import java.io.OutputStream;
import paper.libs.org.tukaani.xz.BlockOutputStream;
import paper.libs.org.tukaani.xz.FilterCoder;
import paper.libs.org.tukaani.xz.FilterEncoder;
import paper.libs.org.tukaani.xz.FilterOptions;
import paper.libs.org.tukaani.xz.FinishableOutputStream;
import paper.libs.org.tukaani.xz.RawCoder;
import paper.libs.org.tukaani.xz.UnsupportedOptionsException;
import paper.libs.org.tukaani.xz.XZ;
import paper.libs.org.tukaani.xz.XZIOException;
import paper.libs.org.tukaani.xz.check.Check;
import paper.libs.org.tukaani.xz.common.EncoderUtil;
import paper.libs.org.tukaani.xz.common.StreamFlags;
import paper.libs.org.tukaani.xz.index.IndexEncoder;

public class XZOutputStream
extends FinishableOutputStream {
    private OutputStream out;
    private final StreamFlags streamFlags = new StreamFlags();
    private final Check check;
    private final IndexEncoder index = new IndexEncoder();
    private BlockOutputStream blockEncoder = null;
    private FilterEncoder[] filters;
    private boolean filtersSupportFlushing;
    private IOException exception = null;
    private boolean finished = false;

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions) throws IOException {
        this(outputStream, filterOptions, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, int n) throws IOException {
        this(outputStream, new FilterOptions[]{filterOptions}, n);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray) throws IOException {
        this(outputStream, filterOptionsArray, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray, int n) throws IOException {
        this.out = outputStream;
        this.updateFilters(filterOptionsArray);
        this.streamFlags.checkType = n;
        this.check = Check.getInstance(n);
        this.encodeStreamHeader();
    }

    public void updateFilters(FilterOptions filterOptions) throws XZIOException {
        FilterOptions[] filterOptionsArray = new FilterOptions[]{filterOptions};
        this.updateFilters(filterOptionsArray);
    }

    public void updateFilters(FilterOptions[] filterOptionsArray) throws XZIOException {
        if (this.blockEncoder != null) {
            throw new UnsupportedOptionsException("Changing filter options in the middle of a XZ Block not implemented");
        }
        if (filterOptionsArray.length < 1 || filterOptionsArray.length > 4) {
            throw new UnsupportedOptionsException("XZ filter chain must be 1-4 filters");
        }
        this.filtersSupportFlushing = true;
        FilterCoder[] filterCoderArray = new FilterEncoder[filterOptionsArray.length];
        for (int j = 0; j < filterOptionsArray.length; ++j) {
            filterCoderArray[j] = filterOptionsArray[j].getFilterEncoder();
            this.filtersSupportFlushing &= filterCoderArray[j].supportsFlushing();
        }
        RawCoder.validate(filterCoderArray);
        this.filters = filterCoderArray;
    }

    public void write(int n) throws IOException {
        byte[] byArray2 = new byte[]{(byte)n};
        this.write(byArray2, 0, 1);
    }

    public void write(byte[] byArray2, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray2.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder == null) {
                this.blockEncoder = new BlockOutputStream(this.out, this.filters, this.check);
            }
            this.blockEncoder.write(byArray2, n, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void endBlock() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.blockEncoder != null) {
            try {
                this.blockEncoder.finish();
                this.index.add(this.blockEncoder.getUnpaddedSize(), this.blockEncoder.getUncompressedSize());
                this.blockEncoder = null;
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder != null) {
                if (this.filtersSupportFlushing) {
                    this.blockEncoder.flush();
                } else {
                    this.endBlock();
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.endBlock();
            try {
                this.index.encode(this.out);
                this.encodeStreamFooter();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void encodeStreamFlags(byte[] byArray2, int n) {
        byArray2[n] = 0;
        byArray2[n + 1] = (byte)this.streamFlags.checkType;
    }

    private void encodeStreamHeader() throws IOException {
        this.out.write(XZ.HEADER_MAGIC);
        byte[] byArray2 = new byte[2];
        this.encodeStreamFlags(byArray2, 0);
        this.out.write(byArray2);
        EncoderUtil.writeCRC32(this.out, byArray2);
    }

    private void encodeStreamFooter() throws IOException {
        byte[] byArray2 = new byte[6];
        long l = this.index.getIndexSize() / 4L - 1L;
        for (int j = 0; j < 4; ++j) {
            byArray2[j] = (byte)(l >>> j * 8);
        }
        this.encodeStreamFlags(byArray2, 4);
        EncoderUtil.writeCRC32(this.out, byArray2);
        this.out.write(byArray2);
        this.out.write(XZ.FOOTER_MAGIC);
    }
}

