/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.curseforgegradle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class CurseForgeGradlePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getLogger().debug("Applying CurseForgeGradle plugin to project {}", (Object)project.getDisplayName());
    }

    public static Reader fetch(String urlString, @Nullable String token) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "CurseForgeGradle");
        connection.setRequestProperty("Accept-Encoding", "gzip");
        if (token != null) {
            connection.addRequestProperty("X-Api-Token", token);
        }
        return CurseForgeGradlePlugin.getHttpReader(connection);
    }

    private static Reader getHttpReader(HttpURLConnection connection) throws IOException {
        if ("gzip".equals(connection.getContentEncoding())) {
            return new InputStreamReader(new GZIPInputStream(connection.getInputStream()));
        }
        return new InputStreamReader(connection.getInputStream());
    }

    public static String readString(Reader read) throws IOException {
        try (BufferedReader input = new BufferedReader(read);){
            String nextLine;
            StringBuilder output = new StringBuilder();
            while ((nextLine = input.readLine()) != null) {
                output.append(nextLine);
            }
            String string = output.toString();
            return string;
        }
    }
}

