/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.curseforgegradle;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.darkhax.curseforgegradle.UploadArtifact;
import net.darkhax.curseforgegradle.VersionDetector;
import net.darkhax.curseforgegradle.api.versions.GameVersions;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;

public abstract class TaskPublishCurseForge
extends DefaultTask {
    private final String projectDisplayName = this.getProject().getDisplayName();
    private final Logger log;
    @Nullable
    private GameVersions validGameVersions;
    private final VersionDetector versionDetector;
    private final List<UploadArtifact> uploadArtifacts = new LinkedList<UploadArtifact>();
    public Object apiEndpoint = "https://minecraft.curseforge.com";
    public Object apiToken;
    public boolean debugMode;

    public TaskPublishCurseForge() {
        this.log = Logging.getLogger((String)("CurseForgeGradle/" + this.projectDisplayName + "/" + this.getName()));
        this.versionDetector = new VersionDetector(this.getProject(), this.log);
        Task buildTask = (Task)this.getProject().getTasks().findByName("build");
        if (buildTask != null) {
            this.mustRunAfter(new Object[]{this.getProject().getTasks().getByName("build")});
        }
    }

    @Nested
    public List<UploadArtifact> getUploadArtifacts() {
        return ImmutableList.copyOf(this.uploadArtifacts);
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    public UploadArtifact upload(Object projectId, Object toUpload) {
        UploadArtifact artifact = new UploadArtifact(toUpload, TaskPublishCurseForge.parseLong(projectId), this.getObjectFactory(), this.log, null);
        this.uploadArtifacts.add(artifact);
        return artifact;
    }

    public UploadArtifact upload(Object projectId, Object toUpload, Action<UploadArtifact> action) {
        UploadArtifact artifact = this.upload(projectId, toUpload);
        action.execute((Object)artifact);
        return artifact;
    }

    public void disableVersionDetection() {
        this.versionDetector.isEnabled = false;
    }

    @TaskAction
    public void apply() {
        if (!this.uploadArtifacts.isEmpty()) {
            this.initialize();
            this.publish();
        } else {
            this.log.warn("No upload artifacts were specified.");
        }
    }

    private void initialize() {
        this.log.debug("Initializing upload task.");
        if (this.apiToken == null) {
            this.log.error("No API token was provided. The file could not be published!");
            throw new GradleException("Can not publish to CurseForge. No API token provided!");
        }
        this.log.debug("Task configured to connect to {}", this.apiEndpoint);
        this.validGameVersions = new GameVersions(TaskPublishCurseForge.parseString(this.apiEndpoint), this.projectDisplayName, this.getName());
        this.validGameVersions.refresh(TaskPublishCurseForge.parseString(this.apiToken));
        if (this.versionDetector.isEnabled) {
            this.versionDetector.detectVersions(this.validGameVersions);
            for (String detectedVersion : this.versionDetector.getDetectedVersions()) {
                for (UploadArtifact artifact : this.uploadArtifacts) {
                    artifact.addGameVersion(detectedVersion);
                }
            }
        }
    }

    private void publish() {
        String tokenString = TaskPublishCurseForge.parseString(this.apiToken);
        String endpointString = TaskPublishCurseForge.parseString(this.apiEndpoint);
        for (UploadArtifact artifact : this.uploadArtifacts) {
            this.uploadArtifact(artifact, endpointString, tokenString);
            for (UploadArtifact childArtifact : artifact.getAdditionalArtifacts()) {
                this.uploadArtifact(childArtifact, endpointString, tokenString);
            }
        }
    }

    private void uploadArtifact(UploadArtifact artifact, String endpoint, String token) {
        artifact.prepareForUpload(this.validGameVersions);
        if (this.debugMode) {
            artifact.logUploadMetadata(endpoint);
        } else {
            artifact.beginUpload(endpoint, token);
        }
    }

    public static Long parseLong(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        throw new GradleException("Could not parse long from " + obj.getClass().getName() + " of value " + obj);
    }

    public static String parseString(Object obj) {
        if (obj instanceof Closure) {
            try {
                obj = ((Closure)obj).call();
            }
            catch (Exception e) {
                throw new GradleException("Could not resolve closure as a string.", (Throwable)e);
            }
        }
        if (obj instanceof Provider) {
            try {
                obj = ((Provider)obj).get();
            }
            catch (Exception e) {
                throw new GradleException("Could not resolve Provider as a string.", (Throwable)e);
            }
        }
        if (obj instanceof RegularFile) {
            obj = ((RegularFile)obj).getAsFile();
        }
        if (obj instanceof File) {
            try {
                return new String(Files.readAllBytes(((File)obj).toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new GradleException("Could not parse File " + ((File)obj).getPath() + " as string.", (Throwable)e);
            }
        }
        return obj != null ? obj.toString() : null;
    }
}

