/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.curseforgegradle;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.darkhax.curseforgegradle.Constants;
import net.darkhax.curseforgegradle.TaskPublishCurseForge;
import net.darkhax.curseforgegradle.api.metadata.Metadata;
import net.darkhax.curseforgegradle.api.metadata.ProjectRelations;
import net.darkhax.curseforgegradle.api.upload.ResponseError;
import net.darkhax.curseforgegradle.api.upload.ResponseSuccessful;
import net.darkhax.curseforgegradle.api.versions.GameVersions;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;

public class UploadArtifact {
    private final ObjectFactory objectFactory;
    private final Logger log;
    private final Long projectId;
    private final UploadArtifact parent;
    private final FileCollection artifact;
    @Nullable
    private File uploadFile = null;
    @Nullable
    @Internal
    private Long curseFileId;
    @Nullable
    private Set<Long> uploadVersions;
    private final List<UploadArtifact> additionalFiles = new ArrayList<UploadArtifact>();
    private Map<String, String> relationships = new HashMap<String, String>();
    private final ProjectRelations uploadRelations = new ProjectRelations();
    public Object changelog = null;
    public Object changelogType = "text";
    public Object displayName = null;
    public Set<String> gameVersions = new HashSet<String>();
    public Object releaseType = "alpha";

    protected UploadArtifact(Object artifact, Long projectId, ObjectFactory objectFactory, Logger log, @Nullable UploadArtifact parent) {
        this.objectFactory = objectFactory;
        this.log = log;
        this.projectId = projectId;
        this.parent = parent;
        ConfigurableFileCollection artifactContainer = objectFactory.fileCollection().from(new Object[]{artifact});
        artifactContainer.disallowChanges();
        this.artifact = artifactContainer;
    }

    @InputFiles
    public FileCollection getArtifact() {
        return this.artifact;
    }

    public UploadArtifact withAdditionalFile(Object file) {
        if (this.parent != null) {
            this.log.error("Artifact {} is a child of artifact {}. Artifacts must only be nested one layer deep!", (Object)this, (Object)this.parent);
            throw new GradleException("Child artifacts must not have their own children. Artifacts can only be nested one layer deep.");
        }
        UploadArtifact subFile = new UploadArtifact(file, this.projectId, this.objectFactory, this.log, this);
        subFile.changelogType = this.changelogType;
        subFile.changelog = this.changelog;
        subFile.releaseType = this.releaseType;
        subFile.relationships = new HashMap<String, String>(this.relationships);
        this.additionalFiles.add(subFile);
        return subFile;
    }

    public void addIncompatibility(Object ... slugs) {
        this.addRelations("incompatible", slugs);
    }

    public void addRequirement(Object ... slugs) {
        this.addRelations("requiredDependency", slugs);
    }

    public void addEmbedded(Object ... slugs) {
        this.addRelations("embeddedLibrary", slugs);
    }

    public void addTool(Object ... slugs) {
        this.addRelations("tool", slugs);
    }

    public void addOptional(Object ... slugs) {
        this.addRelations("optionalDependency", slugs);
    }

    public void addModLoader(Object ... modloaders) {
        this.addGameVersion(modloaders);
    }

    public void addEnvironment(Object ... environments) {
        this.addGameVersion(environments);
    }

    public void addJavaVersion(Object ... javaVersions) {
        this.addGameVersion(javaVersions);
    }

    public void addGameVersion(Object ... gameVersions) {
        if (this.parent != null) {
            StringJoiner versionString = new StringJoiner(", ");
            for (Object gameVersion : gameVersions) {
                versionString.add(TaskPublishCurseForge.parseString(gameVersion));
            }
            this.log.error("Attempted to set the version of an additional file. This is not allowed! versions={}", (Object)versionString);
            throw new GradleException("Sub files can not have their own versions!");
        }
        for (Object gameVersion : gameVersions) {
            String versionString = TaskPublishCurseForge.parseString(gameVersion);
            this.gameVersions.add(versionString);
        }
    }

    public void addRelations(Object type, Object ... slugs) {
        for (Object slug : slugs) {
            this.addRelation(slug, type);
        }
    }

    public void addRelation(Object slug, Object type) {
        String slugString = TaskPublishCurseForge.parseString(slug);
        String existingRelation = this.relationships.get(slugString);
        String typeString = TaskPublishCurseForge.parseString(type);
        if (!Constants.VALID_RELATION_TYPES.contains(typeString)) {
            this.log.warn("Unknown relation type {} was defined for project {}.", (Object)typeString, (Object)slugString);
        }
        if (existingRelation != null) {
            if (typeString == null) {
                this.relationships.remove(slugString);
                this.log.warn("Relation with project {} has been removed.", (Object)slugString);
            } else {
                this.log.warn("Changing relation type for project {} from {} to {}.", new Object[]{slugString, existingRelation, typeString});
            }
        }
        if (typeString != null) {
            this.relationships.put(slugString, typeString);
        }
    }

    public final void prepareForUpload(GameVersions validGameVersions) {
        this.uploadFile = this.artifact.getSingleFile();
        if (!this.uploadFile.exists()) {
            this.log.error("Could not find the file to upload. Expected {}", (Object)this.uploadFile.getAbsolutePath());
            throw new GradleException("The expected upload artifact does not exist!", (Throwable)new FileNotFoundException(this.uploadFile.getAbsolutePath()));
        }
        this.log.debug("Preparing to upload file {}.", (Object)this.uploadFile.getName());
        String parsedChangelogType = TaskPublishCurseForge.parseString(this.changelogType);
        String parsedReleaseType = TaskPublishCurseForge.parseString(this.releaseType);
        if (!Constants.VALID_CHANGELOG_TYPES.contains(parsedChangelogType)) {
            this.log.warn("Changelog type {} is not recognized. This may cause issues!", (Object)parsedChangelogType);
        }
        if (!Constants.VALID_RELEASE_TYPES.contains(parsedReleaseType)) {
            this.log.warn("Release type {} is not recognized. This may cause issues!", (Object)parsedReleaseType);
        }
        for (Map.Entry<String, String> relation : this.relationships.entrySet()) {
            String projectSlug = relation.getKey();
            String relationType = relation.getValue();
            this.log.debug("File {} will have a {} relationship to project {}.", new Object[]{this.uploadFile.getName(), relationType, projectSlug});
            if (!Constants.VALID_RELATION_TYPES.contains(relation.getValue())) {
                this.log.warn("The relation type {} to project {} for file {} is not recognized.", new Object[]{relationType, projectSlug, this.uploadFile.getName()});
            }
            this.uploadRelations.addRelationship(projectSlug, relationType);
        }
        this.uploadVersions = validGameVersions.resolveVersions(this.gameVersions);
    }

    private String getUploadTarget(String endpoint) {
        return endpoint + "/api/projects/" + this.projectId + "/upload-file";
    }

    public final void logUploadMetadata(String endpoint) {
        this.log.lifecycle("Upload file URI for {}: {}", new Object[]{this.uploadFile.getName(), this.getUploadTarget(endpoint)});
        this.log.lifecycle(Constants.PRETTY_GSON.toJson((Object)this.createMetadata()));
        StringJoiner prettyVersions = new StringJoiner(", ");
        for (String gameVersion : this.gameVersions) {
            prettyVersions.add(gameVersion);
        }
        this.log.lifecycle("Game versions: {}", new Object[]{prettyVersions});
    }

    public final void beginUpload(String endpoint, String token) {
        CloseableHttpClient webClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setUserAgent("CurseForgeGradle").build();
        MultipartEntityBuilder requestEntity = MultipartEntityBuilder.create();
        requestEntity.addTextBody("metadata", Constants.GSON.toJson((Object)this.createMetadata()), ContentType.APPLICATION_JSON);
        requestEntity.addBinaryBody("file", this.uploadFile);
        HttpPost request = new HttpPost(this.getUploadTarget(endpoint));
        request.addHeader("X-Api-Token", token);
        request.setEntity(requestEntity.build());
        try {
            this.log.debug("Initiating upload of {}.", (Object)this.uploadFile.getName());
            HttpResponse response = webClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                int errorCode = response.getStatusLine().getStatusCode();
                String message = response.getStatusLine().getReasonPhrase();
                if (response.getFirstHeader("content-type").getValue().contains("json")) {
                    InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());
                    ResponseError error = (ResponseError)Constants.GSON.fromJson((Reader)reader, ResponseError.class);
                    reader.close();
                    errorCode = error.getCode();
                    message = error.getMessage();
                }
                this.log.error("Curse rejected artifact {} with error code '{}' and message '{}'.", new Object[]{this.uploadFile.getName(), errorCode, message});
                throw new GradleException("Failed to upload artifact " + this.uploadFile.getName() + ". Error code '" + errorCode + "', message '" + message + "'.");
            }
            InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());
            this.curseFileId = ((ResponseSuccessful)Constants.GSON.fromJson((Reader)reader, ResponseSuccessful.class)).getId();
            reader.close();
            this.log.debug("Artifact {} uploaded with ID {}.", (Object)this.uploadFile.getName(), (Object)this.curseFileId);
        }
        catch (IOException e) {
            this.log.error("Failed to upload artifact {}!", (Object)this.uploadFile.getName());
            throw new GradleException("Failed to upload artifact!", (Throwable)e);
        }
    }

    @Nested
    public final Collection<UploadArtifact> getAdditionalArtifacts() {
        return ImmutableList.copyOf(this.additionalFiles);
    }

    private Metadata createMetadata() {
        Metadata request = new Metadata();
        request.changelog = TaskPublishCurseForge.parseString(this.changelog);
        request.changelogType = TaskPublishCurseForge.parseString(this.changelogType);
        request.displayName = TaskPublishCurseForge.parseString(this.displayName);
        request.releaseType = TaskPublishCurseForge.parseString(this.releaseType);
        if (!this.uploadRelations.getRelations().isEmpty()) {
            request.relations = this.uploadRelations;
        }
        if (this.parent == null) {
            request.gameVersions = this.uploadVersions;
        }
        if (this.parent != null) {
            request.gameVersions = null;
            request.parentFileID = this.parent.curseFileId;
        }
        return request;
    }

    @Nullable
    public Long getCurseFileId() {
        return this.curseFileId;
    }
}

