/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.curseforgegradle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.darkhax.curseforgegradle.TaskPublishCurseForge;
import net.darkhax.curseforgegradle.api.versions.GameVersions;
import org.apache.groovy.util.Maps;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public final class VersionDetector {
    private static final Map<String, String> WELL_KNOWN_PLUGINS = Maps.of((Object)"net.minecraftforge.gradle", (Object)"Forge", (Object)"fabric-loom", (Object)"Fabric", (Object)"org.quiltmc.loom", (Object)"Quilt", (Object)"net.neoforged.gradle", (Object)"NeoForge", (Object)"net.neoforged.gradle.userdev", (Object)"NeoForge");
    private static final Set<String> WELL_KNOWN_PROPERTIES = Sets.newHashSet((Object[])new String[]{"MC_VERSION", "minecraft_version", "mc_version", "mcVersion", "minecraftVersion"});
    private final Logger log;
    private final Set<String> detectedVersions = new HashSet<String>();
    public boolean isEnabled = true;
    private final Map<String, String> detectedPluginVersions = new HashMap<String, String>();
    private final Map<String, Provider<String>> detectedProperties = new HashMap<String, Provider<String>>();

    VersionDetector(Project project, Logger log) {
        this.log = log;
        WELL_KNOWN_PLUGINS.forEach((pluginName, version) -> project.getPlugins().withId(pluginName, plugin -> this.detectedPluginVersions.put((String)pluginName, (String)version)));
        WELL_KNOWN_PROPERTIES.forEach(propertyName -> {
            Provider propertyProvider = project.hasProperty(propertyName) ? project.provider(() -> TaskPublishCurseForge.parseString(project.findProperty(propertyName))) : project.getProviders().gradleProperty(propertyName);
            propertyProvider = propertyProvider.orElse((Object)"");
            this.detectedProperties.put((String)propertyName, (Provider<String>)propertyProvider);
        });
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (extension != null) {
            Property languageVersion = extension.getToolchain().getLanguageVersion();
            this.detectedProperties.put("JavaVersion", (Provider<String>)languageVersion.map(JavaLanguageVersion::asInt).filter(version -> version > 0).map(version -> "Java " + version).orElse((Object)""));
        }
    }

    public void detectVersions(GameVersions validGameVersions) {
        if (this.isEnabled) {
            this.detectedPluginVersions.forEach((pluginName, version) -> {
                if (this.addDetectedChecked(validGameVersions, (String)version)) {
                    this.log.debug("Detected plugin '{}'. Automatically applying version '{}'.", pluginName, version);
                }
            });
            this.detectedProperties.forEach((propertyName, provider) -> {
                String propertyValue = (String)provider.get();
                if (!propertyValue.isEmpty() && this.addDetectedChecked(validGameVersions, propertyValue)) {
                    this.log.debug("Detected property '{}'. Automatically applying version '{}'.", propertyName, (Object)propertyValue);
                }
            });
        }
    }

    public Collection<String> getDetectedVersions() {
        return ImmutableList.copyOf(this.detectedVersions);
    }

    private boolean addDetectedChecked(GameVersions validGameVersions, String version) {
        if (validGameVersions.getVersion(version) != null) {
            return this.detectedVersions.add(version);
        }
        return false;
    }
}

