/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.curseforgegradle.api.versions;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.darkhax.curseforgegradle.Constants;
import net.darkhax.curseforgegradle.CurseForgeGradlePlugin;
import net.darkhax.curseforgegradle.api.versions.Version;
import net.darkhax.curseforgegradle.api.versions.VersionType;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class GameVersions {
    private final Logger log;
    private final String versionsEndpoint;
    private final String versionTypesEndpoint;
    private final Set<Long> validVersionTypes = new HashSet<Long>();
    private final Map<String, Version> versionsByName = new HashMap<String, Version>();
    private final Map<String, Version> versionsBySlug = new HashMap<String, Version>();

    public GameVersions(String endpoint, String projectName, String taskName) {
        this.versionsEndpoint = endpoint + "/api/game/versions";
        this.versionTypesEndpoint = endpoint + "/api/game/version-types";
        this.log = Logging.getLogger((String)("CurseForgeGradle/Versions/" + projectName + "/" + taskName));
    }

    public void refresh(String apiToken) {
        this.fetchValidVersionTypes(apiToken);
        this.fetchVersions(apiToken);
    }

    private void fetchValidVersionTypes(String apiToken) {
        this.validVersionTypes.clear();
        this.log.debug("Fetching game version types from {}.", (Object)this.versionTypesEndpoint);
        try (Reader versionReader = CurseForgeGradlePlugin.fetch(this.versionTypesEndpoint, apiToken);){
            String response = CurseForgeGradlePlugin.readString(versionReader);
            try {
                VersionType[] versionTypes;
                for (VersionType type : versionTypes = (VersionType[])Constants.GSON.fromJson(response, VersionType[].class)) {
                    if (type.getSlug().startsWith("minecraft") || type.getSlug().equals("java") || type.getSlug().equals("modloader") || type.getSlug().equals("environment")) {
                        this.validVersionTypes.add(type.getId());
                    }
                    this.log.debug("Received game version type {} with id {}.", (Object)type.getName(), (Object)type.getId());
                }
            }
            catch (JsonParseException jsonException) {
                this.log.error("Unexpected response from CurseForge API! " + response);
                throw new GradleException("Unexpected response from CurseForge API. Response '" + response + "'.", (Throwable)jsonException);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to fetch game version types!", (Throwable)e);
            throw new GradleException("Failed to fetch game versions!", (Throwable)e);
        }
    }

    private void fetchVersions(String apiToken) {
        this.versionsByName.clear();
        this.versionsBySlug.clear();
        this.log.debug("Fetching game versions from {}.", (Object)this.versionsEndpoint);
        try (Reader versionReader = CurseForgeGradlePlugin.fetch(this.versionsEndpoint, apiToken);){
            Version[] versions;
            for (Version version : versions = (Version[])Constants.GSON.fromJson(versionReader, Version[].class)) {
                if (this.validVersionTypes.contains(version.getGameVersionTypeID())) {
                    this.versionsByName.compute(version.getName(), (name, existing) -> {
                        if (existing != null) {
                            this.log.warn("Version name {} was already present. Former ID {}. New ID {}.", new Object[]{version.getName(), existing.getId(), version.getId()});
                        }
                        return version;
                    });
                    this.versionsBySlug.compute(version.getSlug(), (slug, existing) -> {
                        if (existing != null) {
                            this.log.warn("Version slug {} was already present. Former ID {}. New ID {}.", new Object[]{version.getSlug(), existing.getId(), version.getId()});
                        }
                        return version;
                    });
                }
                this.log.debug("Received game version {} with id {}.", (Object)version.getName(), (Object)version.getId());
            }
        }
        catch (IOException e) {
            this.log.error("Failed to fetch game versions!", (Throwable)e);
            throw new GradleException("Failed to fetch game versions!", (Throwable)e);
        }
    }

    public Version getVersion(String versionString) {
        Version foundVersion = null;
        foundVersion = this.versionsByName.get(versionString);
        if (foundVersion == null) {
            foundVersion = this.versionsBySlug.get(versionString);
        }
        return foundVersion;
    }

    public Set<Long> resolveVersions(Set<String> toResolve) {
        HashSet<Long> validVersions = new HashSet<Long>();
        for (String versionCandidate : toResolve) {
            Version resolved = this.getVersion(versionCandidate);
            if (resolved == null) {
                this.log.error("Version {} is not valid for this game!", (Object)versionCandidate);
                throw new GradleException("Version " + versionCandidate + " is not valid for this game!");
            }
            validVersions.add(resolved.getId());
        }
        return validVersions;
    }
}

