/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.biome.v1;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.biome.modification.BuiltInRegistryKeys;
import net.minecraft.class_1959;
import net.minecraft.class_2975;
import net.minecraft.class_3504;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5471;

/**
 * Context given to a biome selector for deciding whether it applies to a biome or not.
 *
 * <p><b>Experimental feature</b>, may be removed or changed without further notice.
 */
@Deprecated
public interface BiomeSelectionContext {
	class_5321<class_1959> getBiomeKey();

	/**
	 * Returns the biome with modifications by biome modifiers of higher priority already applied.
	 */
	class_1959 getBiome();

	/**
	 * Returns true if this biome uses the given built-in surface builder, which must be registered
	 * in the {@link net.minecraft.class_5458}.
	 *
	 * <p>This method is intended for use with the Vanilla surface builders found in {@link class_5471}.
	 */
	default boolean hasBuiltInSurfaceBuilder(class_3504<?> surfaceBuilder) {
		class_5321<class_3504<?>> key = BuiltInRegistryKeys.get(surfaceBuilder);
		return hasSurfaceBuilder(key);
	}

	/**
	 * Returns true if this biome uses a surface builder that has the given key.
	 */
	default boolean hasSurfaceBuilder(class_5321<class_3504<?>> key) {
		return getSurfaceBuilderKey().orElse(null) == key;
	}

	/**
	 * Tries to retrieve the registry key for this biomes current surface builder, which may be empty, if the
	 * surface builder is not registered.
	 */
	Optional<class_5321<class_3504<?>>> getSurfaceBuilderKey();

	/**
	 * Returns true if this biome has the given configured feature, which must be registered
	 * in the {@link net.minecraft.class_5458}.
	 *
	 * <p>This method is intended for use with the Vanilla configured features found in {@link net.minecraft.class_5464}.
	 */
	default boolean hasBuiltInFeature(class_2975<?, ?> configuredFeature) {
		class_5321<class_2975<?, ?>> key = BuiltInRegistryKeys.get(configuredFeature);
		return hasFeature(key);
	}

	/**
	 * Returns true if this biome contains a configured feature with the given key.
	 */
	default boolean hasFeature(class_5321<class_2975<?, ?>> key) {
		List<List<Supplier<class_2975<?, ?>>>> featureSteps = getBiome().method_30970().method_30983();

		for (List<Supplier<class_2975<?, ?>>> featureSuppliers : featureSteps) {
			for (Supplier<class_2975<?, ?>> featureSupplier : featureSuppliers) {
				if (getFeatureKey(featureSupplier.get()).orElse(null) == key) {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * Tries to retrieve the registry key for the given configured feature, which should be from this biomes
	 * current feature list. May be empty if the configured feature is not registered, or does not come
	 * from this biomes feature list.
	 */
	Optional<class_5321<class_2975<?, ?>>> getFeatureKey(class_2975<?, ?> configuredFeature);

	/**
	 * Returns true if the given built-in configured structure from {@link net.minecraft.class_5458}
	 * can start in this biome.
	 *
	 * <p>This method is intended for use with the Vanilla configured structures found in {@link net.minecraft.class_5470}.
	 */
	default boolean hasBuiltInStructure(class_5312<?, ?> configuredStructure) {
		class_5321<class_5312<?, ?>> key = BuiltInRegistryKeys.get(configuredStructure);
		return hasStructure(key);
	}

	/**
	 * Returns true if the configured structure with the given key can start in this biome.
	 */
	default boolean hasStructure(class_5321<class_5312<?, ?>> key) {
		Collection<Supplier<class_5312<?, ?>>> structureFeatures = getBiome().method_30970().method_30975();

		for (Supplier<class_5312<?, ?>> supplier : structureFeatures) {
			if (getStructureKey(supplier.get()).orElse(null) == key) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Tries to retrieve the registry key for the given configured feature, which should be from this biomes
	 * current feature list. May be empty if the configured feature is not registered, or does not come
	 * from this biomes feature list.
	 */
	Optional<class_5321<class_5312<?, ?>>> getStructureKey(class_5312<?, ?> configuredStructure);
}
