/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.biome.modification;

import java.util.Optional;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2975;
import net.minecraft.class_3504;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

@ApiStatus.Internal
public class BiomeSelectionContextImpl implements BiomeSelectionContext {
	private final class_5321<class_1959> key;
	private final class_1959 biome;
	private final class_5455 dynamicRegistries;

	public BiomeSelectionContextImpl(class_5455 dynamicRegistries, class_5321<class_1959> key, class_1959 biome) {
		this.key = key;
		this.biome = biome;
		this.dynamicRegistries = dynamicRegistries;
	}

	@Override
	public class_5321<class_1959> getBiomeKey() {
		return key;
	}

	@Override
	public class_1959 getBiome() {
		return biome;
	}

	@Override
	public Optional<class_5321<class_3504<?>>> getSurfaceBuilderKey() {
		class_2378<class_3504<?>> registry = dynamicRegistries.method_30530(class_2378.field_25912);
		return registry.method_29113(biome.method_30970().method_30984().get());
	}

	@Override
	public Optional<class_5321<class_2975<?, ?>>> getFeatureKey(class_2975<?, ?> configuredFeature) {
		class_2378<class_2975<?, ?>> registry = dynamicRegistries.method_30530(class_2378.field_25914);
		return registry.method_29113(configuredFeature);
	}

	@Override
	public Optional<class_5321<class_5312<?, ?>>> getStructureKey(class_5312<?, ?> configuredStructure) {
		class_2378<class_5312<?, ?>> registry = dynamicRegistries.method_30530(class_2378.field_25915);
		return registry.method_29113(configuredStructure);
	}
}
