/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.biome.v1.OverworldBiomes;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.InternalBiomeUtils;
import net.minecraft.class_1959;
import net.minecraft.class_3630;
import net.minecraft.class_3655;
import net.minecraft.class_5321;
import net.minecraft.class_5504;

/**
 * Adds edges and shores specified in {@link OverworldBiomes#addEdgeBiome(class_5321, class_5321, double)} and {@link OverworldBiomes#addShoreBiome(class_5321, class_5321, double)} to the edges layer.
 */
@Mixin(class_3655.class)
public class MixinAddEdgeBiomesLayer {
	@Inject(at = @At("HEAD"), method = "sample", cancellable = true)
	private void sample(class_3630 rand, int north, int east, int south, int west, int center, CallbackInfoReturnable<Integer> info) {
		class_5321<class_1959> centerBiome = class_5504.method_31144(center);

		if (InternalBiomeData.getOverworldShores().containsKey(centerBiome) && InternalBiomeUtils.neighborsOcean(north, east, south, west)) {
			info.setReturnValue(InternalBiomeUtils.getRawId(InternalBiomeData.getOverworldShores().get(centerBiome).pickRandom(rand)));
		} else if (InternalBiomeData.getOverworldEdges().containsKey(centerBiome) && InternalBiomeUtils.isEdge(north, east, south, west, center)) {
			info.setReturnValue(InternalBiomeUtils.getRawId(InternalBiomeData.getOverworldEdges().get(centerBiome).pickRandom(rand)));
		}
	}
}
